/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible
abstract class AbstractTable<R, C, V>
implements Table<R, C, V> {
    private transient Set<Table.Cell<R, C, V>> cellSet;
    private transient Collection<V> values;

    AbstractTable() {
    }

    public boolean containsRow(@Nullable Object rowKey) {
        return Maps.safeContainsKey((Map)this.rowMap(), (Object)rowKey);
    }

    public boolean containsColumn(@Nullable Object columnKey) {
        return Maps.safeContainsKey((Map)this.columnMap(), (Object)columnKey);
    }

    public Set<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    public Set<C> columnKeySet() {
        return this.columnMap().keySet();
    }

    public boolean containsValue(@Nullable Object value) {
        for (Map row : this.rowMap().values()) {
            if (!row.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        Map row = (Map)Maps.safeGet((Map)this.rowMap(), (Object)rowKey);
        return row != null && Maps.safeContainsKey((Map)row, (Object)columnKey);
    }

    public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        Map row = (Map)Maps.safeGet((Map)this.rowMap(), (Object)rowKey);
        return (V)(row == null ? null : Maps.safeGet((Map)row, (Object)columnKey));
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        Iterators.clear(this.cellSet().iterator());
    }

    @CanIgnoreReturnValue
    public V remove(@Nullable Object rowKey, @Nullable Object columnKey) {
        Map row = (Map)Maps.safeGet((Map)this.rowMap(), (Object)rowKey);
        return (V)(row == null ? null : Maps.safeRemove((Map)row, (Object)columnKey));
    }

    @CanIgnoreReturnValue
    public V put(R rowKey, C columnKey, V value) {
        return this.row(rowKey).put(columnKey, value);
    }

    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        for (Table.Cell cell : table.cellSet()) {
            this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }

    public Set<Table.Cell<R, C, V>> cellSet() {
        Set result = this.cellSet;
        return result == null ? (this.cellSet = this.createCellSet()) : result;
    }

    Set<Table.Cell<R, C, V>> createCellSet() {
        return new CellSet(this);
    }

    abstract Iterator<Table.Cell<R, C, V>> cellIterator();

    public Collection<V> values() {
        Collection result = this.values;
        return result == null ? (this.values = this.createValues()) : result;
    }

    Collection<V> createValues() {
        return new Values(this);
    }

    Iterator<V> valuesIterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean equals(@Nullable Object obj) {
        return Tables.equalsImpl((Table)this, (Object)obj);
    }

    public int hashCode() {
        return this.cellSet().hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }
}

