/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.DescendingMultiset;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedMultisets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;

@GwtCompatible(emulated=true)
abstract class DescendingMultiset<E>
extends ForwardingMultiset<E>
implements SortedMultiset<E> {
    private transient Comparator<? super E> comparator;
    private transient NavigableSet<E> elementSet;
    private transient Set<Multiset.Entry<E>> entrySet;

    DescendingMultiset() {
    }

    abstract SortedMultiset<E> forwardMultiset();

    public Comparator<? super E> comparator() {
        Comparator result = this.comparator;
        if (result == null) {
            this.comparator = Ordering.from((Comparator)this.forwardMultiset().comparator()).reverse();
            return this.comparator;
        }
        return result;
    }

    public NavigableSet<E> elementSet() {
        NavigableSet result = this.elementSet;
        if (result == null) {
            this.elementSet = new SortedMultisets.NavigableElementSet((SortedMultiset)this);
            return this.elementSet;
        }
        return result;
    }

    public Multiset.Entry<E> pollFirstEntry() {
        return this.forwardMultiset().pollLastEntry();
    }

    public Multiset.Entry<E> pollLastEntry() {
        return this.forwardMultiset().pollFirstEntry();
    }

    public SortedMultiset<E> headMultiset(E toElement, BoundType boundType) {
        return this.forwardMultiset().tailMultiset(toElement, boundType).descendingMultiset();
    }

    public SortedMultiset<E> subMultiset(E fromElement, BoundType fromBoundType, E toElement, BoundType toBoundType) {
        return this.forwardMultiset().subMultiset(toElement, toBoundType, fromElement, fromBoundType).descendingMultiset();
    }

    public SortedMultiset<E> tailMultiset(E fromElement, BoundType boundType) {
        return this.forwardMultiset().headMultiset(fromElement, boundType).descendingMultiset();
    }

    protected Multiset<E> delegate() {
        return this.forwardMultiset();
    }

    public SortedMultiset<E> descendingMultiset() {
        return this.forwardMultiset();
    }

    public Multiset.Entry<E> firstEntry() {
        return this.forwardMultiset().lastEntry();
    }

    public Multiset.Entry<E> lastEntry() {
        return this.forwardMultiset().firstEntry();
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator();

    public Set<Multiset.Entry<E>> entrySet() {
        Set result = this.entrySet;
        return result == null ? (this.entrySet = this.createEntrySet()) : result;
    }

    Set<Multiset.Entry<E>> createEntrySet() {
        return new EntrySetImpl(this);
    }

    public Iterator<E> iterator() {
        return Multisets.iteratorImpl((Multiset)this);
    }

    public Object[] toArray() {
        return this.standardToArray();
    }

    public <T> T[] toArray(T[] array) {
        return this.standardToArray((Object[])array);
    }

    public String toString() {
        return this.entrySet().toString();
    }
}

