/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.FilteredKeyMultimap;
import com.google.common.collect.FilteredMultimap;
import com.google.common.collect.FilteredMultimapValues;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible
class FilteredKeyMultimap<K, V>
extends AbstractMultimap<K, V>
implements FilteredMultimap<K, V> {
    final Multimap<K, V> unfiltered;
    final Predicate<? super K> keyPredicate;

    FilteredKeyMultimap(Multimap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        this.unfiltered = (Multimap)Preconditions.checkNotNull(unfiltered);
        this.keyPredicate = (Predicate)Preconditions.checkNotNull(keyPredicate);
    }

    public Multimap<K, V> unfiltered() {
        return this.unfiltered;
    }

    public Predicate<? super Map.Entry<K, V>> entryPredicate() {
        return Maps.keyPredicateOnEntries((Predicate)this.keyPredicate);
    }

    public int size() {
        int size = 0;
        for (Collection collection : this.asMap().values()) {
            size += collection.size();
        }
        return size;
    }

    public boolean containsKey(@Nullable Object key) {
        if (this.unfiltered.containsKey(key)) {
            Object k = key;
            return this.keyPredicate.apply(k);
        }
        return false;
    }

    public Collection<V> removeAll(Object key) {
        return this.containsKey(key) ? this.unfiltered.removeAll(key) : this.unmodifiableEmptyCollection();
    }

    Collection<V> unmodifiableEmptyCollection() {
        if (this.unfiltered instanceof SetMultimap) {
            return ImmutableSet.of();
        }
        return ImmutableList.of();
    }

    public void clear() {
        this.keySet().clear();
    }

    Set<K> createKeySet() {
        return Sets.filter((Set)this.unfiltered.keySet(), (Predicate)this.keyPredicate);
    }

    public Collection<V> get(K key) {
        if (this.keyPredicate.apply(key)) {
            return this.unfiltered.get(key);
        }
        if (this.unfiltered instanceof SetMultimap) {
            return new AddRejectingSet(key);
        }
        return new AddRejectingList(key);
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    Collection<Map.Entry<K, V>> createEntries() {
        return new Entries(this);
    }

    Collection<V> createValues() {
        return new FilteredMultimapValues((FilteredMultimap)this);
    }

    Map<K, Collection<V>> createAsMap() {
        return Maps.filterKeys((Map)this.unfiltered.asMap(), (Predicate)this.keyPredicate);
    }

    Multiset<K> createKeys() {
        return Multisets.filter((Multiset)this.unfiltered.keys(), (Predicate)this.keyPredicate);
    }
}

