/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.RegularImmutableAsList;
import com.google.common.collect.RegularImmutableMultiset;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMultiset<E>
extends ImmutableCollection<E>
implements Multiset<E> {
    @LazyInit
    private transient ImmutableList<E> asList;
    @LazyInit
    private transient ImmutableSet<Multiset.Entry<E>> entrySet;

    public static <E> ImmutableMultiset<E> of() {
        return RegularImmutableMultiset.EMPTY;
    }

    public static <E> ImmutableMultiset<E> of(E element) {
        return ImmutableMultiset.copyFromElements((Object[])new Object[]{element});
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2) {
        return ImmutableMultiset.copyFromElements((Object[])new Object[]{e1, e2});
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3) {
        return ImmutableMultiset.copyFromElements((Object[])new Object[]{e1, e2, e3});
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableMultiset.copyFromElements((Object[])new Object[]{e1, e2, e3, e4});
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableMultiset.copyFromElements((Object[])new Object[]{e1, e2, e3, e4, e5});
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        return new Builder().add(e1).add(e2).add(e3).add(e4).add(e5).add(e6).add((Object[])others).build();
    }

    public static <E> ImmutableMultiset<E> copyOf(E[] elements) {
        return ImmutableMultiset.copyFromElements((Object[])elements);
    }

    public static <E> ImmutableMultiset<E> copyOf(Iterable<? extends E> elements) {
        ImmutableMultiset result;
        if (elements instanceof ImmutableMultiset && !(result = (ImmutableMultiset)elements).isPartialView()) {
            return result;
        }
        Multiset multiset = elements instanceof Multiset ? Multisets.cast(elements) : LinkedHashMultiset.create(elements);
        return ImmutableMultiset.copyFromEntries((Collection)multiset.entrySet());
    }

    private static <E> ImmutableMultiset<E> copyFromElements(E ... elements) {
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        Collections.addAll(multiset, elements);
        return ImmutableMultiset.copyFromEntries((Collection)multiset.entrySet());
    }

    static <E> ImmutableMultiset<E> copyFromEntries(Collection<? extends Multiset.Entry<? extends E>> entries) {
        if (entries.isEmpty()) {
            return ImmutableMultiset.of();
        }
        return new RegularImmutableMultiset(entries);
    }

    public static <E> ImmutableMultiset<E> copyOf(Iterator<? extends E> elements) {
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        Iterators.addAll((Collection)multiset, elements);
        return ImmutableMultiset.copyFromEntries((Collection)multiset.entrySet());
    }

    ImmutableMultiset() {
    }

    public UnmodifiableIterator<E> iterator() {
        UnmodifiableIterator entryIterator = this.entrySet().iterator();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ImmutableList<E> asList() {
        ImmutableList result = this.asList;
        return result == null ? (this.asList = this.createAsList()) : result;
    }

    ImmutableList<E> createAsList() {
        if (this.isEmpty()) {
            return ImmutableList.of();
        }
        return new RegularImmutableAsList((ImmutableCollection)this, this.toArray());
    }

    public boolean contains(@Nullable Object object) {
        return this.count(object) > 0;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final int add(E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final int remove(Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final int setCount(E element, int count) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final boolean setCount(E element, int oldCount, int newCount) {
        throw new UnsupportedOperationException();
    }

    @GwtIncompatible
    int copyIntoArray(Object[] dst, int offset) {
        for (Multiset.Entry entry : this.entrySet()) {
            Arrays.fill(dst, offset, offset + entry.getCount(), entry.getElement());
            offset += entry.getCount();
        }
        return offset;
    }

    public boolean equals(@Nullable Object object) {
        return Multisets.equalsImpl((Multiset)this, (Object)object);
    }

    public int hashCode() {
        return Sets.hashCodeImpl((Set)this.entrySet());
    }

    public String toString() {
        return this.entrySet().toString();
    }

    public ImmutableSet<Multiset.Entry<E>> entrySet() {
        ImmutableSet es = this.entrySet;
        return es == null ? (this.entrySet = this.createEntrySet()) : es;
    }

    private final ImmutableSet<Multiset.Entry<E>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new EntrySet(this, null);
    }

    abstract Multiset.Entry<E> getEntry(int var1);

    Object writeReplace() {
        return new SerializedForm((Multiset)this);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }
}

