/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Cut;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedLists;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
@GwtIncompatible
public class ImmutableRangeMap<K extends Comparable<?>, V>
implements RangeMap<K, V>,
Serializable {
    private static final ImmutableRangeMap<Comparable<?>, Object> EMPTY = new ImmutableRangeMap(ImmutableList.of(), ImmutableList.of());
    private final transient ImmutableList<Range<K>> ranges;
    private final transient ImmutableList<V> values;
    private static final long serialVersionUID = 0L;

    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> of() {
        return EMPTY;
    }

    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> of(Range<K> range, V value) {
        return new ImmutableRangeMap(ImmutableList.of(range), ImmutableList.of(value));
    }

    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> copyOf(RangeMap<K, ? extends V> rangeMap) {
        if (rangeMap instanceof ImmutableRangeMap) {
            return (ImmutableRangeMap)rangeMap;
        }
        Map map = rangeMap.asMapOfRanges();
        ImmutableList.Builder rangesBuilder = new ImmutableList.Builder(map.size());
        ImmutableList.Builder valuesBuilder = new ImmutableList.Builder(map.size());
        for (Map.Entry entry : map.entrySet()) {
            rangesBuilder.add(entry.getKey());
            valuesBuilder.add(entry.getValue());
        }
        return new ImmutableRangeMap(rangesBuilder.build(), valuesBuilder.build());
    }

    public static <K extends Comparable<?>, V> Builder<K, V> builder() {
        return new Builder();
    }

    ImmutableRangeMap(ImmutableList<Range<K>> ranges, ImmutableList<V> values) {
        this.ranges = ranges;
        this.values = values;
    }

    @Nullable
    public V get(K key) {
        int index = SortedLists.binarySearch((List)this.ranges, (Function)Range.lowerBoundFn(), (Comparable)Cut.belowValue(key), (SortedLists.KeyPresentBehavior)SortedLists.KeyPresentBehavior.ANY_PRESENT, (SortedLists.KeyAbsentBehavior)SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        if (index == -1) {
            return null;
        }
        Range range = (Range)this.ranges.get(index);
        return (V)(range.contains(key) ? this.values.get(index) : null);
    }

    @Nullable
    public Map.Entry<Range<K>, V> getEntry(K key) {
        int index = SortedLists.binarySearch((List)this.ranges, (Function)Range.lowerBoundFn(), (Comparable)Cut.belowValue(key), (SortedLists.KeyPresentBehavior)SortedLists.KeyPresentBehavior.ANY_PRESENT, (SortedLists.KeyAbsentBehavior)SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        if (index == -1) {
            return null;
        }
        Range range = (Range)this.ranges.get(index);
        return range.contains(key) ? Maps.immutableEntry((Object)range, (Object)this.values.get(index)) : null;
    }

    public Range<K> span() {
        if (this.ranges.isEmpty()) {
            throw new NoSuchElementException();
        }
        Range firstRange = (Range)this.ranges.get(0);
        Range lastRange = (Range)this.ranges.get(this.ranges.size() - 1);
        return Range.create((Cut)firstRange.lowerBound, (Cut)lastRange.upperBound);
    }

    @Deprecated
    public void put(Range<K> range, V value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void putAll(RangeMap<K, V> rangeMap) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void remove(Range<K> range) {
        throw new UnsupportedOperationException();
    }

    public ImmutableMap<Range<K>, V> asMapOfRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        RegularImmutableSortedSet rangeSet = new RegularImmutableSortedSet(this.ranges, (Comparator)Range.RANGE_LEX_ORDERING);
        return new ImmutableSortedMap(rangeSet, this.values);
    }

    public ImmutableMap<Range<K>, V> asDescendingMapOfRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        RegularImmutableSortedSet rangeSet = new RegularImmutableSortedSet(this.ranges.reverse(), (Comparator)Range.RANGE_LEX_ORDERING.reverse());
        return new ImmutableSortedMap(rangeSet, this.values.reverse());
    }

    public ImmutableRangeMap<K, V> subRangeMap(Range<K> range) {
        int upperIndex;
        if (((Range)Preconditions.checkNotNull(range)).isEmpty()) {
            return ImmutableRangeMap.of();
        }
        if (this.ranges.isEmpty() || range.encloses(this.span())) {
            return this;
        }
        int lowerIndex = SortedLists.binarySearch((List)this.ranges, (Function)Range.upperBoundFn(), (Comparable)range.lowerBound, (SortedLists.KeyPresentBehavior)SortedLists.KeyPresentBehavior.FIRST_AFTER, (SortedLists.KeyAbsentBehavior)SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
        if (lowerIndex >= (upperIndex = SortedLists.binarySearch((List)this.ranges, (Function)Range.lowerBoundFn(), (Comparable)range.upperBound, (SortedLists.KeyPresentBehavior)SortedLists.KeyPresentBehavior.ANY_PRESENT, (SortedLists.KeyAbsentBehavior)SortedLists.KeyAbsentBehavior.NEXT_HIGHER))) {
            return ImmutableRangeMap.of();
        }
        int off = lowerIndex;
        int len = upperIndex - lowerIndex;
        1 subRanges = new /* Unavailable Anonymous Inner Class!! */;
        ImmutableRangeMap outer = this;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int hashCode() {
        return this.asMapOfRanges().hashCode();
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof RangeMap) {
            RangeMap rangeMap = (RangeMap)o;
            return this.asMapOfRanges().equals((Object)rangeMap.asMapOfRanges());
        }
        return false;
    }

    public String toString() {
        return this.asMapOfRanges().toString();
    }

    Object writeReplace() {
        return new SerializedForm(this.asMapOfRanges());
    }

    static /* synthetic */ ImmutableList access$000(ImmutableRangeMap x0) {
        return x0.ranges;
    }
}

