/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMapFauxverideShim;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(serializable=true, emulated=true)
public final class ImmutableSortedMap<K, V>
extends ImmutableSortedMapFauxverideShim<K, V>
implements NavigableMap<K, V> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedMap<Comparable, Object> NATURAL_EMPTY_MAP = new ImmutableSortedMap(ImmutableSortedSet.emptySet((Comparator)Ordering.natural()), ImmutableList.of());
    private final transient RegularImmutableSortedSet<K> keySet;
    private final transient ImmutableList<V> valueList;
    private transient ImmutableSortedMap<K, V> descendingMap;
    private static final long serialVersionUID = 0L;

    static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<? super K> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return ImmutableSortedMap.of();
        }
        return new ImmutableSortedMap(ImmutableSortedSet.emptySet(comparator), ImmutableList.of());
    }

    public static <K, V> ImmutableSortedMap<K, V> of() {
        return NATURAL_EMPTY_MAP;
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1) {
        return ImmutableSortedMap.of((Comparator)Ordering.natural(), k1, v1);
    }

    private static <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator, K k1, V v1) {
        return new ImmutableSortedMap(new RegularImmutableSortedSet(ImmutableList.of(k1), (Comparator)Preconditions.checkNotNull(comparator)), ImmutableList.of(v1));
    }

    private static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> ofEntries(ImmutableMapEntry<K, V> ... entries) {
        return ImmutableSortedMap.fromEntries((Comparator)Ordering.natural(), (boolean)false, entries, (int)entries.length);
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2) {
        return ImmutableSortedMap.ofEntries((ImmutableMapEntry[])new ImmutableMapEntry[]{ImmutableSortedMap.entryOf(k1, v1), ImmutableSortedMap.entryOf(k2, v2)});
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ImmutableSortedMap.ofEntries((ImmutableMapEntry[])new ImmutableMapEntry[]{ImmutableSortedMap.entryOf(k1, v1), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3)});
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableSortedMap.ofEntries((ImmutableMapEntry[])new ImmutableMapEntry[]{ImmutableSortedMap.entryOf(k1, v1), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4)});
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableSortedMap.ofEntries((ImmutableMapEntry[])new ImmutableMapEntry[]{ImmutableSortedMap.entryOf(k1, v1), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5)});
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        Ordering naturalOrder = (Ordering)NATURAL_ORDER;
        return ImmutableSortedMap.copyOfInternal(map, (Comparator)naturalOrder);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        return ImmutableSortedMap.copyOfInternal(map, (Comparator)((Comparator)Preconditions.checkNotNull(comparator)));
    }

    @Beta
    public static <K, V> ImmutableSortedMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Ordering naturalOrder = (Ordering)NATURAL_ORDER;
        return ImmutableSortedMap.copyOf(entries, (Comparator)naturalOrder);
    }

    @Beta
    public static <K, V> ImmutableSortedMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries, Comparator<? super K> comparator) {
        return ImmutableSortedMap.fromEntries((Comparator)((Comparator)Preconditions.checkNotNull(comparator)), (boolean)false, entries);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOfSorted(SortedMap<K, ? extends V> map) {
        ImmutableSortedMap kvMap;
        Comparator comparator = map.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        if (map instanceof ImmutableSortedMap && !(kvMap = (ImmutableSortedMap)map).isPartialView()) {
            return kvMap;
        }
        return ImmutableSortedMap.fromEntries((Comparator)comparator, (boolean)true, map.entrySet());
    }

    private static <K, V> ImmutableSortedMap<K, V> copyOfInternal(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        ImmutableSortedMap kvMap;
        boolean sameComparator = false;
        if (map instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)map;
            Comparator comparator2 = sortedMap.comparator();
            boolean bl = comparator2 == null ? comparator == NATURAL_ORDER : (sameComparator = comparator.equals(comparator2));
        }
        if (sameComparator && map instanceof ImmutableSortedMap && !(kvMap = (ImmutableSortedMap)map).isPartialView()) {
            return kvMap;
        }
        return ImmutableSortedMap.fromEntries(comparator, (boolean)sameComparator, map.entrySet());
    }

    private static <K, V> ImmutableSortedMap<K, V> fromEntries(Comparator<? super K> comparator, boolean sameComparator, Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Map.Entry[] entryArray = (Map.Entry[])Iterables.toArray(entries, (Object[])EMPTY_ENTRY_ARRAY);
        return ImmutableSortedMap.fromEntries(comparator, (boolean)sameComparator, (Map.Entry[])entryArray, (int)entryArray.length);
    }

    private static <K, V> ImmutableSortedMap<K, V> fromEntries(Comparator<? super K> comparator, boolean sameComparator, Map.Entry<K, V>[] entryArray, int size) {
        switch (size) {
            case 0: {
                return ImmutableSortedMap.emptyMap(comparator);
            }
            case 1: {
                return ImmutableSortedMap.of(comparator, entryArray[0].getKey(), entryArray[0].getValue());
            }
        }
        Object[] keys = new Object[size];
        Object[] values = new Object[size];
        if (sameComparator) {
            for (int i = 0; i < size; ++i) {
                K key = entryArray[i].getKey();
                V value = entryArray[i].getValue();
                CollectPreconditions.checkEntryNotNull(key, value);
                keys[i] = key;
                values[i] = value;
            }
        } else {
            Arrays.sort(entryArray, 0, size, Ordering.from(comparator).onKeys());
            K prevKey = entryArray[0].getKey();
            keys[0] = prevKey;
            values[0] = entryArray[0].getValue();
            for (int i = 1; i < size; ++i) {
                K key = entryArray[i].getKey();
                V value = entryArray[i].getValue();
                CollectPreconditions.checkEntryNotNull(key, value);
                keys[i] = key;
                values[i] = value;
                ImmutableSortedMap.checkNoConflict((comparator.compare(prevKey, key) != 0 ? 1 : 0) != 0, (String)"key", entryArray[i - 1], entryArray[i]);
                prevKey = key;
            }
        }
        return new ImmutableSortedMap(new RegularImmutableSortedSet((ImmutableList)new RegularImmutableList(keys), comparator), (ImmutableList)new RegularImmutableList(values));
    }

    public static <K extends Comparable<?>, V> Builder<K, V> naturalOrder() {
        return new Builder((Comparator)Ordering.natural());
    }

    public static <K, V> Builder<K, V> orderedBy(Comparator<K> comparator) {
        return new Builder(comparator);
    }

    public static <K extends Comparable<?>, V> Builder<K, V> reverseOrder() {
        return new Builder((Comparator)Ordering.natural().reverse());
    }

    ImmutableSortedMap(RegularImmutableSortedSet<K> keySet, ImmutableList<V> valueList) {
        this(keySet, valueList, null);
    }

    ImmutableSortedMap(RegularImmutableSortedSet<K> keySet, ImmutableList<V> valueList, ImmutableSortedMap<K, V> descendingMap) {
        this.keySet = keySet;
        this.valueList = valueList;
        this.descendingMap = descendingMap;
    }

    @Override
    public int size() {
        return this.valueList.size();
    }

    @Override
    public V get(@Nullable Object key) {
        int index = this.keySet.indexOf(key);
        return (V)(index == -1 ? null : this.valueList.get(index));
    }

    boolean isPartialView() {
        return this.keySet.isPartialView() || this.valueList.isPartialView();
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return super.entrySet();
    }

    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new EntrySet(this);
    }

    @Override
    public ImmutableSortedSet<K> keySet() {
        return this.keySet;
    }

    @Override
    public ImmutableCollection<V> values() {
        return this.valueList;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keySet().comparator();
    }

    @Override
    public K firstKey() {
        return (K)this.keySet().first();
    }

    @Override
    public K lastKey() {
        return (K)this.keySet().last();
    }

    private ImmutableSortedMap<K, V> getSubMap(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex == this.size()) {
            return this;
        }
        if (fromIndex == toIndex) {
            return ImmutableSortedMap.emptyMap((Comparator)this.comparator());
        }
        return new ImmutableSortedMap(this.keySet.getSubSet(fromIndex, toIndex), this.valueList.subList(fromIndex, toIndex));
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K toKey, boolean inclusive) {
        return this.getSubMap(0, this.keySet.headIndex(Preconditions.checkNotNull(toKey), inclusive));
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        Preconditions.checkNotNull(fromKey);
        Preconditions.checkNotNull(toKey);
        Preconditions.checkArgument((this.comparator().compare(fromKey, toKey) <= 0 ? 1 : 0) != 0, (String)"expected fromKey <= toKey but %s > %s", fromKey, toKey);
        return this.headMap(toKey, toInclusive).tailMap(fromKey, fromInclusive);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return this.getSubMap(this.keySet.tailIndex(Preconditions.checkNotNull(fromKey), inclusive), this.size());
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.headMap(key, false).lastEntry();
    }

    @Override
    public K lowerKey(K key) {
        return (K)Maps.keyOrNull((Map.Entry)this.lowerEntry(key));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.headMap(key, true).lastEntry();
    }

    @Override
    public K floorKey(K key) {
        return (K)Maps.keyOrNull((Map.Entry)this.floorEntry(key));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.tailMap(key, true).firstEntry();
    }

    @Override
    public K ceilingKey(K key) {
        return (K)Maps.keyOrNull((Map.Entry)this.ceilingEntry(key));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.tailMap(key, false).firstEntry();
    }

    @Override
    public K higherKey(K key) {
        return (K)Maps.keyOrNull((Map.Entry)this.higherEntry(key));
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.isEmpty() ? null : (Map.Entry)this.entrySet().asList().get(0);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.isEmpty() ? null : (Map.Entry)this.entrySet().asList().get(this.size() - 1);
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedMap<K, V> descendingMap() {
        ImmutableSortedMap result = this.descendingMap;
        if (result == null) {
            if (this.isEmpty()) {
                result = ImmutableSortedMap.emptyMap((Comparator)Ordering.from((Comparator)this.comparator()).reverse());
                return result;
            }
            result = new ImmutableSortedMap((RegularImmutableSortedSet)this.keySet.descendingSet(), this.valueList.reverse(), this);
            return result;
        }
        return result;
    }

    @Override
    public ImmutableSortedSet<K> navigableKeySet() {
        return this.keySet;
    }

    @Override
    public ImmutableSortedSet<K> descendingKeySet() {
        return this.keySet.descendingSet();
    }

    Object writeReplace() {
        return new SerializedForm(this);
    }

    static /* synthetic */ ImmutableSortedMap access$000(Comparator x0, Object x1, Object x2) {
        return ImmutableSortedMap.of((Comparator)x0, (Object)x1, (Object)x2);
    }

    static /* synthetic */ ImmutableSortedMap access$100(Comparator x0, boolean x1, Map.Entry[] x2, int x3) {
        return ImmutableSortedMap.fromEntries((Comparator)x0, (boolean)x1, (Map.Entry[])x2, (int)x3);
    }

    static /* synthetic */ RegularImmutableSortedSet access$200(ImmutableSortedMap x0) {
        return x0.keySet;
    }

    static /* synthetic */ ImmutableList access$300(ImmutableSortedMap x0) {
        return x0.valueList;
    }
}

