/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractSetMultimap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultimap<K, V>
extends AbstractSetMultimap<K, V> {
    private static final int DEFAULT_KEY_CAPACITY = 16;
    private static final int DEFAULT_VALUE_SET_CAPACITY = 2;
    @VisibleForTesting
    static final double VALUE_SET_LOAD_FACTOR = 1.0;
    @VisibleForTesting
    transient int valueSetCapacity = 2;
    private transient ValueEntry<K, V> multimapHeaderEntry;
    @GwtIncompatible
    private static final long serialVersionUID = 1L;

    public static <K, V> LinkedHashMultimap<K, V> create() {
        return new LinkedHashMultimap(16, 2);
    }

    public static <K, V> LinkedHashMultimap<K, V> create(int expectedKeys, int expectedValuesPerKey) {
        return new LinkedHashMultimap(Maps.capacity((int)expectedKeys), Maps.capacity((int)expectedValuesPerKey));
    }

    public static <K, V> LinkedHashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        LinkedHashMultimap result = LinkedHashMultimap.create((int)multimap.keySet().size(), (int)2);
        result.putAll(multimap);
        return result;
    }

    private static <K, V> void succeedsInValueSet(ValueSetLink<K, V> pred, ValueSetLink<K, V> succ) {
        pred.setSuccessorInValueSet(succ);
        succ.setPredecessorInValueSet(pred);
    }

    private static <K, V> void succeedsInMultimap(ValueEntry<K, V> pred, ValueEntry<K, V> succ) {
        pred.setSuccessorInMultimap(succ);
        succ.setPredecessorInMultimap(pred);
    }

    private static <K, V> void deleteFromValueSet(ValueSetLink<K, V> entry) {
        LinkedHashMultimap.succeedsInValueSet((ValueSetLink)entry.getPredecessorInValueSet(), (ValueSetLink)entry.getSuccessorInValueSet());
    }

    private static <K, V> void deleteFromMultimap(ValueEntry<K, V> entry) {
        LinkedHashMultimap.succeedsInMultimap((ValueEntry)entry.getPredecessorInMultimap(), (ValueEntry)entry.getSuccessorInMultimap());
    }

    private LinkedHashMultimap(int keyCapacity, int valueSetCapacity) {
        super(new LinkedHashMap(keyCapacity));
        CollectPreconditions.checkNonnegative((int)valueSetCapacity, (String)"expectedValuesPerKey");
        this.valueSetCapacity = valueSetCapacity;
        this.multimapHeaderEntry = new ValueEntry(null, null, 0, null);
        LinkedHashMultimap.succeedsInMultimap((ValueEntry)this.multimapHeaderEntry, (ValueEntry)this.multimapHeaderEntry);
    }

    Set<V> createCollection() {
        return new LinkedHashSet(this.valueSetCapacity);
    }

    Collection<V> createCollection(K key) {
        return new ValueSet(this, key, this.valueSetCapacity);
    }

    @CanIgnoreReturnValue
    public Set<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        return super.replaceValues(key, values);
    }

    public Set<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    public Set<K> keySet() {
        return super.keySet();
    }

    public Collection<V> values() {
        return super.values();
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    Iterator<V> valueIterator() {
        return Maps.valueIterator((Iterator)this.entryIterator());
    }

    public void clear() {
        super.clear();
        LinkedHashMultimap.succeedsInMultimap((ValueEntry)this.multimapHeaderEntry, (ValueEntry)this.multimapHeaderEntry);
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.keySet().size());
        for (Object key : this.keySet()) {
            stream.writeObject(key);
        }
        stream.writeInt(this.size());
        for (Map.Entry entry : this.entries()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.multimapHeaderEntry = new ValueEntry(null, null, 0, null);
        LinkedHashMultimap.succeedsInMultimap((ValueEntry)this.multimapHeaderEntry, (ValueEntry)this.multimapHeaderEntry);
        this.valueSetCapacity = 2;
        int distinctKeys = stream.readInt();
        LinkedHashMap<Object, Collection> map = new LinkedHashMap<Object, Collection>();
        for (int i = 0; i < distinctKeys; ++i) {
            Object key = stream.readObject();
            map.put(key, this.createCollection(key));
        }
        int entries = stream.readInt();
        for (int i = 0; i < entries; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            ((Collection)map.get(key)).add(value);
        }
        this.setMap(map);
    }

    static /* synthetic */ void access$200(ValueSetLink x0, ValueSetLink x1) {
        LinkedHashMultimap.succeedsInValueSet((ValueSetLink)x0, (ValueSetLink)x1);
    }

    static /* synthetic */ ValueEntry access$300(LinkedHashMultimap x0) {
        return x0.multimapHeaderEntry;
    }

    static /* synthetic */ void access$400(ValueEntry x0, ValueEntry x1) {
        LinkedHashMultimap.succeedsInMultimap((ValueEntry)x0, (ValueEntry)x1);
    }

    static /* synthetic */ void access$500(ValueSetLink x0) {
        LinkedHashMultimap.deleteFromValueSet((ValueSetLink)x0);
    }

    static /* synthetic */ void access$600(ValueEntry x0) {
        LinkedHashMultimap.deleteFromMultimap((ValueEntry)x0);
    }
}

