/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Collections2;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.Cut;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RegularContiguousSet;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
final class RegularContiguousSet<C extends Comparable>
extends ContiguousSet<C> {
    private final Range<C> range;
    private static final long serialVersionUID = 0L;

    RegularContiguousSet(Range<C> range, DiscreteDomain<C> domain) {
        super(domain);
        this.range = range;
    }

    private ContiguousSet<C> intersectionInCurrentDomain(Range<C> other) {
        return this.range.isConnected(other) ? ContiguousSet.create((Range)this.range.intersection(other), (DiscreteDomain)this.domain) : new EmptyContiguousSet(this.domain);
    }

    ContiguousSet<C> headSetImpl(C toElement, boolean inclusive) {
        return this.intersectionInCurrentDomain(Range.upTo(toElement, (BoundType)BoundType.forBoolean((boolean)inclusive)));
    }

    ContiguousSet<C> subSetImpl(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
        if (fromElement.compareTo(toElement) == 0 && !fromInclusive && !toInclusive) {
            return new EmptyContiguousSet(this.domain);
        }
        return this.intersectionInCurrentDomain(Range.range(fromElement, (BoundType)BoundType.forBoolean((boolean)fromInclusive), toElement, (BoundType)BoundType.forBoolean((boolean)toInclusive)));
    }

    ContiguousSet<C> tailSetImpl(C fromElement, boolean inclusive) {
        return this.intersectionInCurrentDomain(Range.downTo(fromElement, (BoundType)BoundType.forBoolean((boolean)inclusive)));
    }

    @GwtIncompatible
    int indexOf(Object target) {
        return this.contains(target) ? (int)this.domain.distance(this.first(), (Comparable)target) : -1;
    }

    public UnmodifiableIterator<C> iterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @GwtIncompatible
    public UnmodifiableIterator<C> descendingIterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static boolean equalsOrThrow(Comparable<?> left, @Nullable Comparable<?> right) {
        return right != null && Range.compareOrThrow(left, right) == 0;
    }

    boolean isPartialView() {
        return false;
    }

    public C first() {
        return (C)this.range.lowerBound.leastValueAbove(this.domain);
    }

    public C last() {
        return (C)this.range.upperBound.greatestValueBelow(this.domain);
    }

    public int size() {
        long distance = this.domain.distance(this.first(), this.last());
        return distance >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)distance + 1;
    }

    public boolean contains(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        try {
            return this.range.contains((Comparable)object);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean containsAll(Collection<?> targets) {
        return Collections2.containsAllImpl((Collection)this, targets);
    }

    public boolean isEmpty() {
        return false;
    }

    public ContiguousSet<C> intersection(ContiguousSet<C> other) {
        Comparable upperEndpoint;
        Preconditions.checkNotNull(other);
        Preconditions.checkArgument((boolean)this.domain.equals(other.domain));
        if (other.isEmpty()) {
            return other;
        }
        Comparable lowerEndpoint = (Comparable)Ordering.natural().max((Object)this.first(), other.first());
        return lowerEndpoint.compareTo(upperEndpoint = (Comparable)Ordering.natural().min((Object)this.last(), other.last())) <= 0 ? ContiguousSet.create((Range)Range.closed((Comparable)lowerEndpoint, (Comparable)upperEndpoint), (DiscreteDomain)this.domain) : new EmptyContiguousSet(this.domain);
    }

    public Range<C> range() {
        return this.range(BoundType.CLOSED, BoundType.CLOSED);
    }

    public Range<C> range(BoundType lowerBoundType, BoundType upperBoundType) {
        return Range.create((Cut)this.range.lowerBound.withLowerBoundType(lowerBoundType, this.domain), (Cut)this.range.upperBound.withUpperBoundType(upperBoundType, this.domain));
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RegularContiguousSet) {
            RegularContiguousSet that = (RegularContiguousSet)object;
            if (this.domain.equals(that.domain)) {
                return this.first().equals(that.first()) && this.last().equals(that.last());
            }
        }
        return super.equals(object);
    }

    public int hashCode() {
        return Sets.hashCodeImpl((Set)this);
    }

    @GwtIncompatible
    Object writeReplace() {
        return new SerializedForm(this.range, this.domain, null);
    }

    static /* synthetic */ boolean access$000(Comparable x0, Comparable x1) {
        return RegularContiguousSet.equalsOrThrow((Comparable)x0, (Comparable)x1);
    }
}

