/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RegularImmutableBiMap;
import com.google.common.collect.RegularImmutableMap;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final RegularImmutableBiMap<Object, Object> EMPTY = new RegularImmutableBiMap(null, null, ImmutableMap.EMPTY_ENTRY_ARRAY, 0, 0);
    static final double MAX_LOAD_FACTOR = 1.2;
    private final transient ImmutableMapEntry<K, V>[] keyTable;
    private final transient ImmutableMapEntry<K, V>[] valueTable;
    private final transient Map.Entry<K, V>[] entries;
    private final transient int mask;
    private final transient int hashCode;
    @LazyInit
    @RetainedWith
    private transient ImmutableBiMap<V, K> inverse;

    static <K, V> RegularImmutableBiMap<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        return RegularImmutableBiMap.fromEntryArray((int)entries.length, (Map.Entry[])entries);
    }

    static <K, V> RegularImmutableBiMap<K, V> fromEntryArray(int n, Map.Entry<K, V>[] entryArray) {
        Preconditions.checkPositionIndex((int)n, (int)entryArray.length);
        int tableSize = Hashing.closedTableSize((int)n, (double)1.2);
        int mask = tableSize - 1;
        ImmutableMapEntry[] keyTable = ImmutableMapEntry.createEntryArray((int)tableSize);
        ImmutableMapEntry[] valueTable = ImmutableMapEntry.createEntryArray((int)tableSize);
        Map.Entry[] entries = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray((int)n);
        int hashCode = 0;
        for (int i = 0; i < n; ++i) {
            ImmutableMapEntry.NonTerminalImmutableBiMapEntry newEntry;
            Map.Entry<K, V> entry = entryArray[i];
            K key = entry.getKey();
            V value = entry.getValue();
            CollectPreconditions.checkEntryNotNull(key, value);
            int keyHash = key.hashCode();
            int valueHash = value.hashCode();
            int keyBucket = Hashing.smear((int)keyHash) & mask;
            int valueBucket = Hashing.smear((int)valueHash) & mask;
            ImmutableMapEntry nextInKeyBucket = keyTable[keyBucket];
            RegularImmutableMap.checkNoConflictInKeyBucket(key, entry, (ImmutableMapEntry)nextInKeyBucket);
            ImmutableMapEntry nextInValueBucket = valueTable[valueBucket];
            RegularImmutableBiMap.checkNoConflictInValueBucket(value, entry, (ImmutableMapEntry)nextInValueBucket);
            if (nextInValueBucket == null && nextInKeyBucket == null) {
                boolean reusable = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
                newEntry = reusable ? (ImmutableMapEntry)entry : new ImmutableMapEntry(key, value);
            } else {
                newEntry = new ImmutableMapEntry.NonTerminalImmutableBiMapEntry(key, value, nextInKeyBucket, nextInValueBucket);
            }
            keyTable[keyBucket] = newEntry;
            valueTable[valueBucket] = newEntry;
            entries[i] = newEntry;
            hashCode += keyHash ^ valueHash;
        }
        return new RegularImmutableBiMap(keyTable, valueTable, entries, mask, hashCode);
    }

    private RegularImmutableBiMap(ImmutableMapEntry<K, V>[] keyTable, ImmutableMapEntry<K, V>[] valueTable, Map.Entry<K, V>[] entries, int mask, int hashCode) {
        this.keyTable = keyTable;
        this.valueTable = valueTable;
        this.entries = entries;
        this.mask = mask;
        this.hashCode = hashCode;
    }

    private static void checkNoConflictInValueBucket(Object value, Map.Entry<?, ?> entry, @Nullable ImmutableMapEntry<?, ?> valueBucketHead) {
        while (valueBucketHead != null) {
            RegularImmutableBiMap.checkNoConflict((!value.equals(valueBucketHead.getValue()) ? 1 : 0) != 0, (String)"value", entry, valueBucketHead);
            valueBucketHead = valueBucketHead.getNextInValueBucket();
        }
    }

    @Nullable
    public V get(@Nullable Object key) {
        return (V)(this.keyTable == null ? null : RegularImmutableMap.get((Object)key, (ImmutableMapEntry[])this.keyTable, (int)this.mask));
    }

    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new ImmutableMapEntrySet.RegularEntrySet((ImmutableMap)this, this.entries);
    }

    boolean isHashCodeFast() {
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    boolean isPartialView() {
        return false;
    }

    public int size() {
        return this.entries.length;
    }

    public ImmutableBiMap<V, K> inverse() {
        if (this.isEmpty()) {
            return ImmutableBiMap.of();
        }
        ImmutableBiMap result = this.inverse;
        return result == null ? (this.inverse = new Inverse(this, null)) : result;
    }

    static /* synthetic */ ImmutableMapEntry[] access$100(RegularImmutableBiMap x0) {
        return x0.valueTable;
    }

    static /* synthetic */ int access$200(RegularImmutableBiMap x0) {
        return x0.mask;
    }

    static /* synthetic */ int access$300(RegularImmutableBiMap x0) {
        return x0.hashCode;
    }

    static /* synthetic */ Map.Entry[] access$400(RegularImmutableBiMap x0) {
        return x0.entries;
    }
}

