/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.UnmodifiableListIterator;

@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableList<E>
extends ImmutableList<E> {
    static final ImmutableList<Object> EMPTY = new RegularImmutableList(ObjectArrays.EMPTY_ARRAY);
    private final transient Object[] array;

    RegularImmutableList(Object[] array) {
        this.array = array;
    }

    public int size() {
        return this.array.length;
    }

    boolean isPartialView() {
        return false;
    }

    int copyIntoArray(Object[] dst, int dstOff) {
        System.arraycopy(this.array, 0, dst, dstOff, this.array.length);
        return dstOff + this.array.length;
    }

    public E get(int index) {
        return (E)this.array[index];
    }

    public UnmodifiableListIterator<E> listIterator(int index) {
        return Iterators.forArray((Object[])this.array, (int)0, (int)this.array.length, (int)index);
    }
}

