/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RegularImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map.Entry<K, V>[] entries;
    private final transient ImmutableMapEntry<K, V>[] table;
    private final transient int mask;
    private static final double MAX_LOAD_FACTOR = 1.2;
    private static final long serialVersionUID = 0L;

    static <K, V> RegularImmutableMap<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        return RegularImmutableMap.fromEntryArray((int)entries.length, (Map.Entry[])entries);
    }

    static <K, V> RegularImmutableMap<K, V> fromEntryArray(int n, Map.Entry<K, V>[] entryArray) {
        Preconditions.checkPositionIndex((int)n, (int)entryArray.length);
        Map.Entry[] entries = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray((int)n);
        int tableSize = Hashing.closedTableSize((int)n, (double)1.2);
        ImmutableMapEntry[] table = ImmutableMapEntry.createEntryArray((int)tableSize);
        int mask = tableSize - 1;
        for (int entryIndex = 0; entryIndex < n; ++entryIndex) {
            ImmutableMapEntry.NonTerminalImmutableMapEntry newEntry;
            Map.Entry<K, V> entry = entryArray[entryIndex];
            K key = entry.getKey();
            V value = entry.getValue();
            CollectPreconditions.checkEntryNotNull(key, value);
            int tableIndex = Hashing.smear((int)key.hashCode()) & mask;
            ImmutableMapEntry existing = table[tableIndex];
            if (existing == null) {
                boolean reusable = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
                newEntry = reusable ? (ImmutableMapEntry)entry : new ImmutableMapEntry(key, value);
            } else {
                newEntry = new ImmutableMapEntry.NonTerminalImmutableMapEntry(key, value, existing);
            }
            table[tableIndex] = newEntry;
            entries[entryIndex] = newEntry;
            RegularImmutableMap.checkNoConflictInKeyBucket(key, (Map.Entry)newEntry, (ImmutableMapEntry)existing);
        }
        return new RegularImmutableMap(entries, table, mask);
    }

    private RegularImmutableMap(Map.Entry<K, V>[] entries, ImmutableMapEntry<K, V>[] table, int mask) {
        this.entries = entries;
        this.table = table;
        this.mask = mask;
    }

    static void checkNoConflictInKeyBucket(Object key, Map.Entry<?, ?> entry, @Nullable ImmutableMapEntry<?, ?> keyBucketHead) {
        while (keyBucketHead != null) {
            RegularImmutableMap.checkNoConflict((!key.equals(keyBucketHead.getKey()) ? 1 : 0) != 0, (String)"key", entry, keyBucketHead);
            keyBucketHead = keyBucketHead.getNextInKeyBucket();
        }
    }

    public V get(@Nullable Object key) {
        return (V)RegularImmutableMap.get((Object)key, (ImmutableMapEntry[])this.table, (int)this.mask);
    }

    @Nullable
    static <V> V get(@Nullable Object key, ImmutableMapEntry<?, V>[] keyTable, int mask) {
        if (key == null) {
            return null;
        }
        int index = Hashing.smear((int)key.hashCode()) & mask;
        for (ImmutableMapEntry entry = keyTable[index]; entry != null; entry = entry.getNextInKeyBucket()) {
            Object candidateKey = entry.getKey();
            if (!key.equals(candidateKey)) continue;
            return (V)entry.getValue();
        }
        return null;
    }

    public int size() {
        return this.entries.length;
    }

    boolean isPartialView() {
        return false;
    }

    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet((ImmutableMap)this, this.entries);
    }

    ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    static /* synthetic */ Map.Entry[] access$000(RegularImmutableMap x0) {
        return x0.entries;
    }
}

