/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.RegularImmutableMultiset;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Collection;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    static final RegularImmutableMultiset<Object> EMPTY = new RegularImmutableMultiset((Collection)ImmutableList.of());
    private final transient Multisets.ImmutableEntry<E>[] entries;
    private final transient Multisets.ImmutableEntry<E>[] hashTable;
    private final transient int size;
    private final transient int hashCode;
    @LazyInit
    private transient ImmutableSet<E> elementSet;

    RegularImmutableMultiset(Collection<? extends Multiset.Entry<? extends E>> entries) {
        int distinct = entries.size();
        Multisets.ImmutableEntry[] entryArray = new Multisets.ImmutableEntry[distinct];
        if (distinct == 0) {
            this.entries = entryArray;
            this.hashTable = null;
            this.size = 0;
            this.hashCode = 0;
            this.elementSet = ImmutableSet.of();
        } else {
            int tableSize = Hashing.closedTableSize((int)distinct, (double)1.0);
            int mask = tableSize - 1;
            Multisets.ImmutableEntry[] hashTable = new Multisets.ImmutableEntry[tableSize];
            int index = 0;
            int hashCode = 0;
            long size = 0L;
            for (Multiset.Entry<E> entry : entries) {
                NonTerminalEntry newEntry;
                Object element = Preconditions.checkNotNull((Object)entry.getElement());
                int count = entry.getCount();
                int hash = element.hashCode();
                int bucket = Hashing.smear((int)hash) & mask;
                Multisets.ImmutableEntry bucketHead = hashTable[bucket];
                if (bucketHead == null) {
                    boolean canReuseEntry = entry instanceof Multisets.ImmutableEntry && !(entry instanceof NonTerminalEntry);
                    newEntry = canReuseEntry ? (Multisets.ImmutableEntry)entry : new Multisets.ImmutableEntry(element, count);
                } else {
                    newEntry = new NonTerminalEntry(element, count, bucketHead);
                }
                hashCode += hash ^ count;
                entryArray[index++] = newEntry;
                hashTable[bucket] = newEntry;
                size += (long)count;
            }
            this.entries = entryArray;
            this.hashTable = hashTable;
            this.size = Ints.saturatedCast((long)size);
            this.hashCode = hashCode;
        }
    }

    boolean isPartialView() {
        return false;
    }

    public int count(@Nullable Object element) {
        Multisets.ImmutableEntry[] hashTable = this.hashTable;
        if (element == null || hashTable == null) {
            return 0;
        }
        int hash = Hashing.smearedHash((Object)element);
        int mask = hashTable.length - 1;
        for (Multisets.ImmutableEntry entry = hashTable[hash & mask]; entry != null; entry = entry.nextInBucket()) {
            if (!Objects.equal((Object)element, (Object)entry.getElement())) continue;
            return entry.getCount();
        }
        return 0;
    }

    public int size() {
        return this.size;
    }

    public ImmutableSet<E> elementSet() {
        ImmutableSet result = this.elementSet;
        return result == null ? (this.elementSet = new ElementSet(this, null)) : result;
    }

    Multiset.Entry<E> getEntry(int index) {
        return this.entries[index];
    }

    public int hashCode() {
        return this.hashCode;
    }

    static /* synthetic */ Multisets.ImmutableEntry[] access$100(RegularImmutableMultiset x0) {
        return x0.entries;
    }
}

