/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableList<E>
extends ImmutableList<E> {
    final transient E element;

    SingletonImmutableList(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    public E get(int index) {
        Preconditions.checkElementIndex((int)index, (int)1);
        return (E)this.element;
    }

    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator((Object)this.element);
    }

    public int size() {
        return 1;
    }

    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes((int)fromIndex, (int)toIndex, (int)1);
        return fromIndex == toIndex ? ImmutableList.of() : this;
    }

    public String toString() {
        return '[' + this.element.toString() + ']';
    }

    boolean isPartialView() {
        return false;
    }
}

