/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.GwtTransient;
import com.google.common.collect.Maps;
import com.google.common.collect.StandardTable;
import com.google.common.collect.Table;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible
class StandardTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    @GwtTransient
    final Map<R, Map<C, V>> backingMap;
    @GwtTransient
    final Supplier<? extends Map<C, V>> factory;
    private transient Set<C> columnKeySet;
    private transient Map<R, Map<C, V>> rowMap;
    private transient ColumnMap columnMap;
    private static final long serialVersionUID = 0L;

    StandardTable(Map<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        this.backingMap = backingMap;
        this.factory = factory;
    }

    public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        return rowKey != null && columnKey != null && super.contains(rowKey, columnKey);
    }

    public boolean containsColumn(@Nullable Object columnKey) {
        if (columnKey == null) {
            return false;
        }
        for (Map map : this.backingMap.values()) {
            if (!Maps.safeContainsKey((Map)map, (Object)columnKey)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRow(@Nullable Object rowKey) {
        return rowKey != null && Maps.safeContainsKey((Map)this.backingMap, (Object)rowKey);
    }

    public boolean containsValue(@Nullable Object value) {
        return value != null && super.containsValue(value);
    }

    public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        return (V)(rowKey == null || columnKey == null ? null : super.get(rowKey, columnKey));
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public int size() {
        int size = 0;
        for (Map map : this.backingMap.values()) {
            size += map.size();
        }
        return size;
    }

    public void clear() {
        this.backingMap.clear();
    }

    private Map<C, V> getOrCreate(R rowKey) {
        Map map = (Map)this.backingMap.get(rowKey);
        if (map == null) {
            map = (Map)this.factory.get();
            this.backingMap.put(rowKey, map);
        }
        return map;
    }

    @CanIgnoreReturnValue
    public V put(R rowKey, C columnKey, V value) {
        Preconditions.checkNotNull(rowKey);
        Preconditions.checkNotNull(columnKey);
        Preconditions.checkNotNull(value);
        return this.getOrCreate(rowKey).put(columnKey, value);
    }

    @CanIgnoreReturnValue
    public V remove(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return null;
        }
        Map map = (Map)Maps.safeGet((Map)this.backingMap, (Object)rowKey);
        if (map == null) {
            return null;
        }
        Object value = map.remove(columnKey);
        if (map.isEmpty()) {
            this.backingMap.remove(rowKey);
        }
        return value;
    }

    @CanIgnoreReturnValue
    private Map<R, V> removeColumn(Object column) {
        LinkedHashMap output = new LinkedHashMap();
        Iterator iterator = this.backingMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object value = ((Map)entry.getValue()).remove(column);
            if (value == null) continue;
            output.put(entry.getKey(), value);
            if (!((Map)entry.getValue()).isEmpty()) continue;
            iterator.remove();
        }
        return output;
    }

    private boolean containsMapping(Object rowKey, Object columnKey, Object value) {
        return value != null && value.equals(this.get(rowKey, columnKey));
    }

    private boolean removeMapping(Object rowKey, Object columnKey, Object value) {
        if (this.containsMapping(rowKey, columnKey, value)) {
            this.remove(rowKey, columnKey);
            return true;
        }
        return false;
    }

    public Set<Table.Cell<R, C, V>> cellSet() {
        return super.cellSet();
    }

    Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new CellIterator(this, null);
    }

    public Map<C, V> row(R rowKey) {
        return new Row(this, rowKey);
    }

    public Map<R, V> column(C columnKey) {
        return new Column(this, columnKey);
    }

    public Set<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    public Set<C> columnKeySet() {
        Set result = this.columnKeySet;
        return result == null ? (this.columnKeySet = new ColumnKeySet(this, null)) : result;
    }

    Iterator<C> createColumnKeyIterator() {
        return new ColumnKeyIterator(this, null);
    }

    public Collection<V> values() {
        return super.values();
    }

    public Map<R, Map<C, V>> rowMap() {
        Map result = this.rowMap;
        return result == null ? (this.rowMap = this.createRowMap()) : result;
    }

    Map<R, Map<C, V>> createRowMap() {
        return new RowMap(this);
    }

    public Map<C, Map<R, V>> columnMap() {
        ColumnMap result = this.columnMap;
        return result == null ? (this.columnMap = new ColumnMap(this, null)) : result;
    }

    static /* synthetic */ boolean access$300(StandardTable x0, Object x1, Object x2, Object x3) {
        return x0.containsMapping(x1, x2, x3);
    }

    static /* synthetic */ boolean access$400(StandardTable x0, Object x1, Object x2, Object x3) {
        return x0.removeMapping(x1, x2, x3);
    }

    static /* synthetic */ Map access$900(StandardTable x0, Object x1) {
        return x0.removeColumn(x1);
    }
}

