/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractRangeSet;
import com.google.common.collect.Cut;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.io.Serializable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
@GwtIncompatible
public class TreeRangeSet<C extends Comparable<?>>
extends AbstractRangeSet<C>
implements Serializable {
    @VisibleForTesting
    final NavigableMap<Cut<C>, Range<C>> rangesByLowerBound;
    private transient Set<Range<C>> asRanges;
    private transient Set<Range<C>> asDescendingSetOfRanges;
    private transient RangeSet<C> complement;

    public static <C extends Comparable<?>> TreeRangeSet<C> create() {
        return new TreeRangeSet(new TreeMap());
    }

    public static <C extends Comparable<?>> TreeRangeSet<C> create(RangeSet<C> rangeSet) {
        TreeRangeSet result = TreeRangeSet.create();
        result.addAll(rangeSet);
        return result;
    }

    private TreeRangeSet(NavigableMap<Cut<C>, Range<C>> rangesByLowerCut) {
        this.rangesByLowerBound = rangesByLowerCut;
    }

    public Set<Range<C>> asRanges() {
        Set result = this.asRanges;
        return result == null ? (this.asRanges = new AsRanges(this, this.rangesByLowerBound.values())) : result;
    }

    public Set<Range<C>> asDescendingSetOfRanges() {
        Set result = this.asDescendingSetOfRanges;
        return result == null ? (this.asDescendingSetOfRanges = new AsRanges(this, this.rangesByLowerBound.descendingMap().values())) : result;
    }

    @Nullable
    public Range<C> rangeContaining(C value) {
        Preconditions.checkNotNull(value);
        Map.Entry floorEntry = this.rangesByLowerBound.floorEntry(Cut.belowValue(value));
        if (floorEntry != null && ((Range)floorEntry.getValue()).contains(value)) {
            return (Range)floorEntry.getValue();
        }
        return null;
    }

    public boolean intersects(Range<C> range) {
        Preconditions.checkNotNull(range);
        Map.Entry ceilingEntry = this.rangesByLowerBound.ceilingEntry(range.lowerBound);
        if (ceilingEntry != null && ((Range)ceilingEntry.getValue()).isConnected(range) && !((Range)ceilingEntry.getValue()).intersection(range).isEmpty()) {
            return true;
        }
        Map.Entry priorEntry = this.rangesByLowerBound.lowerEntry(range.lowerBound);
        return priorEntry != null && ((Range)priorEntry.getValue()).isConnected(range) && !((Range)priorEntry.getValue()).intersection(range).isEmpty();
    }

    public boolean encloses(Range<C> range) {
        Preconditions.checkNotNull(range);
        Map.Entry floorEntry = this.rangesByLowerBound.floorEntry(range.lowerBound);
        return floorEntry != null && ((Range)floorEntry.getValue()).encloses(range);
    }

    @Nullable
    private Range<C> rangeEnclosing(Range<C> range) {
        Preconditions.checkNotNull(range);
        Map.Entry floorEntry = this.rangesByLowerBound.floorEntry(range.lowerBound);
        return floorEntry != null && ((Range)floorEntry.getValue()).encloses(range) ? (Range)floorEntry.getValue() : null;
    }

    public Range<C> span() {
        Map.Entry firstEntry = this.rangesByLowerBound.firstEntry();
        Map.Entry lastEntry = this.rangesByLowerBound.lastEntry();
        if (firstEntry == null) {
            throw new NoSuchElementException();
        }
        return Range.create((Cut)((Range)firstEntry.getValue()).lowerBound, (Cut)((Range)lastEntry.getValue()).upperBound);
    }

    public void add(Range<C> rangeToAdd) {
        Map.Entry entryBelowUB;
        Preconditions.checkNotNull(rangeToAdd);
        if (rangeToAdd.isEmpty()) {
            return;
        }
        Cut lbToAdd = rangeToAdd.lowerBound;
        Cut ubToAdd = rangeToAdd.upperBound;
        Map.Entry entryBelowLB = this.rangesByLowerBound.lowerEntry(lbToAdd);
        if (entryBelowLB != null) {
            Range rangeBelowLB = (Range)entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(lbToAdd) >= 0) {
                if (rangeBelowLB.upperBound.compareTo(ubToAdd) >= 0) {
                    ubToAdd = rangeBelowLB.upperBound;
                }
                lbToAdd = rangeBelowLB.lowerBound;
            }
        }
        if ((entryBelowUB = this.rangesByLowerBound.floorEntry(ubToAdd)) != null) {
            Range rangeBelowUB = (Range)entryBelowUB.getValue();
            if (rangeBelowUB.upperBound.compareTo(ubToAdd) >= 0) {
                ubToAdd = rangeBelowUB.upperBound;
            }
        }
        this.rangesByLowerBound.subMap(lbToAdd, ubToAdd).clear();
        this.replaceRangeWithSameLowerBound(Range.create((Cut)lbToAdd, (Cut)ubToAdd));
    }

    public void remove(Range<C> rangeToRemove) {
        Map.Entry entryBelowUB;
        Preconditions.checkNotNull(rangeToRemove);
        if (rangeToRemove.isEmpty()) {
            return;
        }
        Map.Entry entryBelowLB = this.rangesByLowerBound.lowerEntry(rangeToRemove.lowerBound);
        if (entryBelowLB != null) {
            Range rangeBelowLB = (Range)entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(rangeToRemove.lowerBound) >= 0) {
                if (rangeToRemove.hasUpperBound() && rangeBelowLB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                    this.replaceRangeWithSameLowerBound(Range.create((Cut)rangeToRemove.upperBound, (Cut)rangeBelowLB.upperBound));
                }
                this.replaceRangeWithSameLowerBound(Range.create((Cut)rangeBelowLB.lowerBound, (Cut)rangeToRemove.lowerBound));
            }
        }
        if ((entryBelowUB = this.rangesByLowerBound.floorEntry(rangeToRemove.upperBound)) != null) {
            Range rangeBelowUB = (Range)entryBelowUB.getValue();
            if (rangeToRemove.hasUpperBound() && rangeBelowUB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                this.replaceRangeWithSameLowerBound(Range.create((Cut)rangeToRemove.upperBound, (Cut)rangeBelowUB.upperBound));
            }
        }
        this.rangesByLowerBound.subMap(rangeToRemove.lowerBound, rangeToRemove.upperBound).clear();
    }

    private void replaceRangeWithSameLowerBound(Range<C> range) {
        if (range.isEmpty()) {
            this.rangesByLowerBound.remove(range.lowerBound);
        } else {
            this.rangesByLowerBound.put(range.lowerBound, range);
        }
    }

    public RangeSet<C> complement() {
        RangeSet result = this.complement;
        return result == null ? (this.complement = new Complement(this)) : result;
    }

    public RangeSet<C> subRangeSet(Range<C> view) {
        return view.equals((Object)Range.all()) ? this : new SubRangeSet(this, view);
    }

    static /* synthetic */ Range access$600(TreeRangeSet x0, Range x1) {
        return x0.rangeEnclosing(x1);
    }
}

