/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.graph.Graphs;
import com.google.common.graph.NetworkConnections;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

abstract class AbstractDirectedNetworkConnections<N, E>
implements NetworkConnections<N, E> {
    protected final Map<E, N> inEdgeMap;
    protected final Map<E, N> outEdgeMap;
    private int selfLoopCount;

    protected AbstractDirectedNetworkConnections(Map<E, N> inEdgeMap, Map<E, N> outEdgeMap, int selfLoopCount) {
        this.inEdgeMap = (Map)Preconditions.checkNotNull(inEdgeMap);
        this.outEdgeMap = (Map)Preconditions.checkNotNull(outEdgeMap);
        this.selfLoopCount = Graphs.checkNonNegative((int)selfLoopCount);
        Preconditions.checkState((selfLoopCount <= inEdgeMap.size() && selfLoopCount <= outEdgeMap.size() ? 1 : 0) != 0);
    }

    public Set<N> adjacentNodes() {
        return Sets.union((Set)this.predecessors(), (Set)this.successors());
    }

    public Set<E> incidentEdges() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Set<E> inEdges() {
        return Collections.unmodifiableSet(this.inEdgeMap.keySet());
    }

    public Set<E> outEdges() {
        return Collections.unmodifiableSet(this.outEdgeMap.keySet());
    }

    public N oppositeNode(Object edge) {
        return (N)Preconditions.checkNotNull(this.outEdgeMap.get(edge));
    }

    public N removeInEdge(Object edge, boolean isSelfLoop) {
        if (isSelfLoop) {
            Graphs.checkNonNegative((int)(--this.selfLoopCount));
        }
        Object previousNode = this.inEdgeMap.remove(edge);
        return (N)Preconditions.checkNotNull(previousNode);
    }

    public N removeOutEdge(Object edge) {
        Object previousNode = this.outEdgeMap.remove(edge);
        return (N)Preconditions.checkNotNull(previousNode);
    }

    public void addInEdge(E edge, N node, boolean isSelfLoop) {
        N previousNode;
        if (isSelfLoop) {
            Graphs.checkPositive((int)(++this.selfLoopCount));
        }
        Preconditions.checkState(((previousNode = this.inEdgeMap.put(edge, node)) == null ? 1 : 0) != 0);
    }

    public void addOutEdge(E edge, N node) {
        N previousNode = this.outEdgeMap.put(edge, node);
        Preconditions.checkState((previousNode == null ? 1 : 0) != 0);
    }

    static /* synthetic */ int access$000(AbstractDirectedNetworkConnections x0) {
        return x0.selfLoopCount;
    }
}

