/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.math.IntMath;
import java.util.Set;

@Beta
public abstract class AbstractGraph<N>
implements Graph<N> {
    protected long edgeCount() {
        long degreeSum = 0L;
        for (Object node : this.nodes()) {
            degreeSum += (long)this.degree(node);
        }
        Preconditions.checkState(((degreeSum & 1L) == 0L ? 1 : 0) != 0);
        return degreeSum >>> 1;
    }

    public Set<EndpointPair<N>> edges() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int degree(Object node) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd((int)this.predecessors(node).size(), (int)this.successors(node).size());
        }
        Set neighbors = this.adjacentNodes(node);
        int selfLoopCount = this.allowsSelfLoops() && neighbors.contains(node) ? 1 : 0;
        return IntMath.saturatedAdd((int)neighbors.size(), (int)selfLoopCount);
    }

    public int inDegree(Object node) {
        return this.isDirected() ? this.predecessors(node).size() : this.degree(node);
    }

    public int outDegree(Object node) {
        return this.isDirected() ? this.successors(node).size() : this.degree(node);
    }

    public String toString() {
        String propertiesString = String.format("isDirected: %s, allowsSelfLoops: %s", this.isDirected(), this.allowsSelfLoops());
        return String.format("%s, nodes: %s, edges: %s", propertiesString, this.nodes(), this.edges());
    }
}

