/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.AbstractNetwork;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import com.google.common.math.IntMath;
import java.util.Map;
import java.util.Set;

@Beta
public abstract class AbstractNetwork<N, E>
implements Network<N, E> {
    public Graph<N> asGraph() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int degree(Object node) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd((int)this.inEdges(node).size(), (int)this.outEdges(node).size());
        }
        return IntMath.saturatedAdd((int)this.incidentEdges(node).size(), (int)this.edgesConnecting(node, node).size());
    }

    public int inDegree(Object node) {
        return this.isDirected() ? this.inEdges(node).size() : this.degree(node);
    }

    public int outDegree(Object node) {
        return this.isDirected() ? this.outEdges(node).size() : this.degree(node);
    }

    public Set<E> adjacentEdges(Object edge) {
        EndpointPair endpointPair = this.incidentNodes(edge);
        Sets.SetView endpointPairIncidentEdges = Sets.union((Set)this.incidentEdges(endpointPair.nodeU()), (Set)this.incidentEdges(endpointPair.nodeV()));
        return Sets.difference((Set)endpointPairIncidentEdges, (Set)ImmutableSet.of((Object)edge));
    }

    public String toString() {
        String propertiesString = String.format("isDirected: %s, allowsParallelEdges: %s, allowsSelfLoops: %s", this.isDirected(), this.allowsParallelEdges(), this.allowsSelfLoops());
        return String.format("%s, nodes: %s, edges: %s", propertiesString, this.nodes(), this.edgeIncidentNodesMap());
    }

    private Map<E, EndpointPair<N>> edgeIncidentNodesMap() {
        2 edgeToIncidentNodesFn = new /* Unavailable Anonymous Inner Class!! */;
        return Maps.asMap((Set)this.edges(), (Function)edgeToIncidentNodesFn);
    }
}

