/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.graph.AbstractGraph;
import com.google.common.graph.AbstractValueGraph;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ValueGraph;
import java.util.Map;
import java.util.Set;

@Beta
public abstract class AbstractValueGraph<N, V>
extends AbstractGraph<N>
implements ValueGraph<N, V> {
    public V edgeValue(Object nodeU, Object nodeV) {
        Object value = this.edgeValueOrDefault(nodeU, nodeV, null);
        if (value == null) {
            Preconditions.checkArgument((boolean)this.nodes().contains(nodeU), (String)"Node %s is not an element of this graph.", (Object)nodeU);
            Preconditions.checkArgument((boolean)this.nodes().contains(nodeV), (String)"Node %s is not an element of this graph.", (Object)nodeV);
            throw new IllegalArgumentException(String.format("Edge connecting %s to %s is not present in this graph.", nodeU, nodeV));
        }
        return (V)value;
    }

    public String toString() {
        String propertiesString = String.format("isDirected: %s, allowsSelfLoops: %s", this.isDirected(), this.allowsSelfLoops());
        return String.format("%s, nodes: %s, edges: %s", propertiesString, this.nodes(), this.edgeValueMap());
    }

    private Map<EndpointPair<N>, V> edgeValueMap() {
        1 edgeToValueFn = new /* Unavailable Anonymous Inner Class!! */;
        return Maps.asMap((Set)this.edges(), (Function)edgeToValueFn);
    }
}

