/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.ConfigurableNetwork;
import com.google.common.graph.DirectedMultiNetworkConnections;
import com.google.common.graph.DirectedNetworkConnections;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import com.google.common.graph.UndirectedMultiNetworkConnections;
import com.google.common.graph.UndirectedNetworkConnections;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;

final class ConfigurableMutableNetwork<N, E>
extends ConfigurableNetwork<N, E>
implements MutableNetwork<N, E> {
    ConfigurableMutableNetwork(NetworkBuilder<? super N, ? super E> builder) {
        super(builder);
    }

    @CanIgnoreReturnValue
    public boolean addNode(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        if (this.containsNode(node)) {
            return false;
        }
        this.addNodeInternal(node);
        return true;
    }

    @CanIgnoreReturnValue
    private NetworkConnections<N, E> addNodeInternal(N node) {
        NetworkConnections connections = this.newConnections();
        Preconditions.checkState((this.nodeConnections.put(node, (Object)connections) == null ? 1 : 0) != 0);
        return connections;
    }

    @CanIgnoreReturnValue
    public boolean addEdge(N nodeU, N nodeV, E edge) {
        Preconditions.checkNotNull(nodeU, (Object)"nodeU");
        Preconditions.checkNotNull(nodeV, (Object)"nodeV");
        Preconditions.checkNotNull(edge, (Object)"edge");
        if (this.containsEdge(edge)) {
            EndpointPair existingIncidentNodes = this.incidentNodes(edge);
            EndpointPair newIncidentNodes = EndpointPair.of((Network)this, nodeU, nodeV);
            Preconditions.checkArgument((boolean)existingIncidentNodes.equals((Object)newIncidentNodes), (String)"Edge %s already exists between the following nodes: %s, so it cannot be reused to connect the following nodes: %s.", edge, (Object)existingIncidentNodes, (Object)newIncidentNodes);
            return false;
        }
        NetworkConnections connectionsU = (NetworkConnections)this.nodeConnections.get(nodeU);
        if (!this.allowsParallelEdges()) {
            Preconditions.checkArgument((connectionsU == null || !connectionsU.successors().contains(nodeV) ? 1 : 0) != 0, (String)"Nodes %s and %s are already connected by a different edge. To construct a graph that allows parallel edges, call allowsParallelEdges(true) on the Builder.", nodeU, nodeV);
        }
        boolean isSelfLoop = nodeU.equals(nodeV);
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument((!isSelfLoop ? 1 : 0) != 0, (String)"Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", nodeU);
        }
        if (connectionsU == null) {
            connectionsU = this.addNodeInternal(nodeU);
        }
        connectionsU.addOutEdge(edge, nodeV);
        NetworkConnections connectionsV = (NetworkConnections)this.nodeConnections.get(nodeV);
        if (connectionsV == null) {
            connectionsV = this.addNodeInternal(nodeV);
        }
        connectionsV.addInEdge(edge, nodeU, isSelfLoop);
        this.edgeToReferenceNode.put(edge, nodeU);
        return true;
    }

    @CanIgnoreReturnValue
    public boolean removeNode(Object node) {
        Preconditions.checkNotNull((Object)node, (Object)"node");
        NetworkConnections connections = (NetworkConnections)this.nodeConnections.get(node);
        if (connections == null) {
            return false;
        }
        for (Object edge : ImmutableList.copyOf((Collection)connections.incidentEdges())) {
            this.removeEdge(edge);
        }
        this.nodeConnections.remove(node);
        return true;
    }

    @CanIgnoreReturnValue
    public boolean removeEdge(Object edge) {
        Preconditions.checkNotNull((Object)edge, (Object)"edge");
        Object nodeU = this.edgeToReferenceNode.get(edge);
        if (nodeU == null) {
            return false;
        }
        NetworkConnections connectionsU = (NetworkConnections)this.nodeConnections.get(nodeU);
        Object nodeV = connectionsU.oppositeNode(edge);
        NetworkConnections connectionsV = (NetworkConnections)this.nodeConnections.get(nodeV);
        connectionsU.removeOutEdge(edge);
        connectionsV.removeInEdge(edge, this.allowsSelfLoops() && nodeU.equals(nodeV));
        this.edgeToReferenceNode.remove(edge);
        return true;
    }

    private NetworkConnections<N, E> newConnections() {
        return this.isDirected() ? (this.allowsParallelEdges() ? DirectedMultiNetworkConnections.of() : DirectedNetworkConnections.of()) : (this.allowsParallelEdges() ? UndirectedMultiNetworkConnections.of() : UndirectedNetworkConnections.of());
    }
}

