/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.ConfigurableValueGraph;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.UndirectedGraphConnections;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

final class ConfigurableMutableValueGraph<N, V>
extends ConfigurableValueGraph<N, V>
implements MutableValueGraph<N, V> {
    ConfigurableMutableValueGraph(AbstractGraphBuilder<? super N> builder) {
        super(builder);
    }

    @CanIgnoreReturnValue
    public boolean addNode(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        if (this.containsNode(node)) {
            return false;
        }
        this.addNodeInternal(node);
        return true;
    }

    @CanIgnoreReturnValue
    private GraphConnections<N, V> addNodeInternal(N node) {
        GraphConnections connections = this.newConnections();
        Preconditions.checkState((this.nodeConnections.put(node, (Object)connections) == null ? 1 : 0) != 0);
        return connections;
    }

    @CanIgnoreReturnValue
    public V putEdgeValue(N nodeU, N nodeV, V value) {
        GraphConnections connectionsU;
        Preconditions.checkNotNull(nodeU, (Object)"nodeU");
        Preconditions.checkNotNull(nodeV, (Object)"nodeV");
        Preconditions.checkNotNull(value, (Object)"value");
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument((!nodeU.equals(nodeV) ? 1 : 0) != 0, (String)"Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", nodeU);
        }
        if ((connectionsU = (GraphConnections)this.nodeConnections.get(nodeU)) == null) {
            connectionsU = this.addNodeInternal(nodeU);
        }
        Object previousValue = connectionsU.addSuccessor(nodeV, value);
        GraphConnections connectionsV = (GraphConnections)this.nodeConnections.get(nodeV);
        if (connectionsV == null) {
            connectionsV = this.addNodeInternal(nodeV);
        }
        connectionsV.addPredecessor(nodeU, value);
        if (previousValue == null) {
            Graphs.checkPositive((long)(++this.edgeCount));
        }
        return (V)previousValue;
    }

    @CanIgnoreReturnValue
    public boolean removeNode(Object node) {
        Preconditions.checkNotNull((Object)node, (Object)"node");
        GraphConnections connections = (GraphConnections)this.nodeConnections.get(node);
        if (connections == null) {
            return false;
        }
        if (this.allowsSelfLoops() && connections.removeSuccessor(node) != null) {
            connections.removePredecessor(node);
            --this.edgeCount;
        }
        for (Object successor : connections.successors()) {
            ((GraphConnections)this.nodeConnections.getWithoutCaching(successor)).removePredecessor(node);
            --this.edgeCount;
        }
        if (this.isDirected()) {
            for (Object predecessor : connections.predecessors()) {
                Preconditions.checkState((((GraphConnections)this.nodeConnections.getWithoutCaching(predecessor)).removeSuccessor(node) != null ? 1 : 0) != 0);
                --this.edgeCount;
            }
        }
        this.nodeConnections.remove(node);
        Graphs.checkNonNegative((long)this.edgeCount);
        return true;
    }

    @CanIgnoreReturnValue
    public V removeEdge(Object nodeU, Object nodeV) {
        Preconditions.checkNotNull((Object)nodeU, (Object)"nodeU");
        Preconditions.checkNotNull((Object)nodeV, (Object)"nodeV");
        GraphConnections connectionsU = (GraphConnections)this.nodeConnections.get(nodeU);
        GraphConnections connectionsV = (GraphConnections)this.nodeConnections.get(nodeV);
        if (connectionsU == null || connectionsV == null) {
            return null;
        }
        Object previousValue = connectionsU.removeSuccessor(nodeV);
        if (previousValue != null) {
            connectionsV.removePredecessor(nodeU);
            Graphs.checkNonNegative((long)(--this.edgeCount));
        }
        return (V)previousValue;
    }

    private GraphConnections<N, V> newConnections() {
        return this.isDirected() ? DirectedGraphConnections.of() : UndirectedGraphConnections.of();
    }
}

