/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
final class DirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private static final Object PRED = new Object();
    private final Map<N, Object> adjacentNodeValues;
    private int predecessorCount;
    private int successorCount;

    private DirectedGraphConnections(Map<N, Object> adjacentNodeValues, int predecessorCount, int successorCount) {
        this.adjacentNodeValues = (Map)Preconditions.checkNotNull(adjacentNodeValues);
        this.predecessorCount = Graphs.checkNonNegative((int)predecessorCount);
        this.successorCount = Graphs.checkNonNegative((int)successorCount);
        Preconditions.checkState((predecessorCount <= adjacentNodeValues.size() && successorCount <= adjacentNodeValues.size() ? 1 : 0) != 0);
    }

    static <N, V> DirectedGraphConnections<N, V> of() {
        int initialCapacity = 4;
        return new DirectedGraphConnections(new HashMap(initialCapacity, 1.0f), 0, 0);
    }

    static <N, V> DirectedGraphConnections<N, V> ofImmutable(Set<N> predecessors, Map<N, V> successorValues) {
        HashMap<N, Object> adjacentNodeValues = new HashMap<N, Object>();
        adjacentNodeValues.putAll(successorValues);
        for (N predecessor : predecessors) {
            Object value = adjacentNodeValues.put(predecessor, PRED);
            if (value == null) continue;
            adjacentNodeValues.put(predecessor, new PredAndSucc(value));
        }
        return new DirectedGraphConnections((Map)ImmutableMap.copyOf(adjacentNodeValues), predecessors.size(), successorValues.size());
    }

    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
    }

    public Set<N> predecessors() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Set<N> successors() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public V value(Object node) {
        Object value = this.adjacentNodeValues.get(node);
        if (value == PRED) {
            return null;
        }
        if (value instanceof PredAndSucc) {
            return (V)PredAndSucc.access$500((PredAndSucc)((PredAndSucc)value));
        }
        return value;
    }

    public void removePredecessor(Object node) {
        Object previousValue = this.adjacentNodeValues.get(node);
        if (previousValue == PRED) {
            this.adjacentNodeValues.remove(node);
            Graphs.checkNonNegative((int)(--this.predecessorCount));
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, PredAndSucc.access$500((PredAndSucc)((PredAndSucc)previousValue)));
            Graphs.checkNonNegative((int)(--this.predecessorCount));
        }
    }

    public V removeSuccessor(Object node) {
        Object previousValue = this.adjacentNodeValues.get(node);
        if (previousValue == null || previousValue == PRED) {
            return null;
        }
        if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, PRED);
            Graphs.checkNonNegative((int)(--this.successorCount));
            return (V)PredAndSucc.access$500((PredAndSucc)((PredAndSucc)previousValue));
        }
        this.adjacentNodeValues.remove(node);
        Graphs.checkNonNegative((int)(--this.successorCount));
        return previousValue;
    }

    public void addPredecessor(N node, V unused) {
        Object previousValue = this.adjacentNodeValues.put(node, PRED);
        if (previousValue == null) {
            Graphs.checkPositive((int)(++this.predecessorCount));
        } else if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, previousValue);
        } else if (previousValue != PRED) {
            this.adjacentNodeValues.put(node, new PredAndSucc(previousValue));
            Graphs.checkPositive((int)(++this.predecessorCount));
        }
    }

    public V addSuccessor(N node, V value) {
        V previousValue = this.adjacentNodeValues.put(node, value);
        if (previousValue == null) {
            Graphs.checkPositive((int)(++this.successorCount));
            return null;
        }
        if (previousValue instanceof PredAndSucc) {
            this.adjacentNodeValues.put(node, new PredAndSucc(value));
            return (V)PredAndSucc.access$500((PredAndSucc)((PredAndSucc)previousValue));
        }
        if (previousValue == PRED) {
            this.adjacentNodeValues.put(node, new PredAndSucc(value));
            Graphs.checkPositive((int)(++this.successorCount));
            return null;
        }
        return previousValue;
    }

    private static boolean isPredecessor(@Nullable Object value) {
        return value == PRED || value instanceof PredAndSucc;
    }

    private static boolean isSuccessor(@Nullable Object value) {
        return value != PRED && value != null;
    }

    static /* synthetic */ Map access$000(DirectedGraphConnections x0) {
        return x0.adjacentNodeValues;
    }

    static /* synthetic */ boolean access$100(Object x0) {
        return DirectedGraphConnections.isPredecessor((Object)x0);
    }

    static /* synthetic */ int access$200(DirectedGraphConnections x0) {
        return x0.predecessorCount;
    }

    static /* synthetic */ boolean access$300(Object x0) {
        return DirectedGraphConnections.isSuccessor((Object)x0);
    }

    static /* synthetic */ int access$400(DirectedGraphConnections x0) {
        return x0.successorCount;
    }
}

