/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public abstract class EndpointPair<N>
implements Iterable<N> {
    private final N nodeU;
    private final N nodeV;

    private EndpointPair(N nodeU, N nodeV) {
        this.nodeU = Preconditions.checkNotNull(nodeU);
        this.nodeV = Preconditions.checkNotNull(nodeV);
    }

    public static <N> EndpointPair<N> ordered(N source, N target) {
        return new Ordered(source, target, null);
    }

    public static <N> EndpointPair<N> unordered(N nodeU, N nodeV) {
        return new Unordered(nodeV, nodeU, null);
    }

    static <N> EndpointPair<N> of(Graph<?> graph, N nodeU, N nodeV) {
        return graph.isDirected() ? EndpointPair.ordered(nodeU, nodeV) : EndpointPair.unordered(nodeU, nodeV);
    }

    static <N> EndpointPair<N> of(Network<?, ?> network, N nodeU, N nodeV) {
        return network.isDirected() ? EndpointPair.ordered(nodeU, nodeV) : EndpointPair.unordered(nodeU, nodeV);
    }

    public abstract N source();

    public abstract N target();

    public final N nodeU() {
        return (N)this.nodeU;
    }

    public final N nodeV() {
        return (N)this.nodeV;
    }

    public final N adjacentNode(Object node) {
        if (node.equals(this.nodeU)) {
            return (N)this.nodeV;
        }
        if (node.equals(this.nodeV)) {
            return (N)this.nodeU;
        }
        throw new IllegalArgumentException(String.format("EndpointPair %s does not contain node %s", this, node));
    }

    public abstract boolean isOrdered();

    @Override
    public final UnmodifiableIterator<N> iterator() {
        return Iterators.forArray((Object[])new Object[]{this.nodeU, this.nodeV});
    }

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();
}

