/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.ConfigurableNetwork;
import com.google.common.graph.DirectedMultiNetworkConnections;
import com.google.common.graph.DirectedNetworkConnections;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import com.google.common.graph.UndirectedMultiNetworkConnections;
import com.google.common.graph.UndirectedNetworkConnections;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public final class ImmutableNetwork<N, E>
extends ConfigurableNetwork<N, E> {
    private ImmutableNetwork(Network<N, E> network) {
        super(NetworkBuilder.from(network), ImmutableNetwork.getNodeConnections(network), ImmutableNetwork.getEdgeToReferenceNode(network));
    }

    public static <N, E> ImmutableNetwork<N, E> copyOf(Network<N, E> network) {
        return network instanceof ImmutableNetwork ? (ImmutableNetwork)network : new ImmutableNetwork(network);
    }

    @Deprecated
    public static <N, E> ImmutableNetwork<N, E> copyOf(ImmutableNetwork<N, E> network) {
        return (ImmutableNetwork)Preconditions.checkNotNull(network);
    }

    public ImmutableGraph<N> asGraph() {
        Graph asGraph = super.asGraph();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static <N, E> Map<N, NetworkConnections<N, E>> getNodeConnections(Network<N, E> network) {
        ImmutableMap.Builder nodeConnections = ImmutableMap.builder();
        for (Object node : network.nodes()) {
            nodeConnections.put(node, (Object)ImmutableNetwork.connectionsOf(network, node));
        }
        return nodeConnections.build();
    }

    private static <N, E> Map<E, N> getEdgeToReferenceNode(Network<N, E> network) {
        ImmutableMap.Builder edgeToReferenceNode = ImmutableMap.builder();
        for (Object edge : network.edges()) {
            edgeToReferenceNode.put(edge, network.incidentNodes(edge).nodeU());
        }
        return edgeToReferenceNode.build();
    }

    private static <N, E> NetworkConnections<N, E> connectionsOf(Network<N, E> network, N node) {
        if (network.isDirected()) {
            Map inEdgeMap = Maps.asMap((Set)network.inEdges(node), (Function)ImmutableNetwork.sourceNodeFn(network));
            Map outEdgeMap = Maps.asMap((Set)network.outEdges(node), (Function)ImmutableNetwork.targetNodeFn(network));
            int selfLoopCount = network.edgesConnecting(node, node).size();
            return network.allowsParallelEdges() ? DirectedMultiNetworkConnections.ofImmutable((Map)inEdgeMap, (Map)outEdgeMap, (int)selfLoopCount) : DirectedNetworkConnections.ofImmutable((Map)inEdgeMap, (Map)outEdgeMap, (int)selfLoopCount);
        }
        Map incidentEdgeMap = Maps.asMap((Set)network.incidentEdges(node), (Function)ImmutableNetwork.adjacentNodeFn(network, node));
        return network.allowsParallelEdges() ? UndirectedMultiNetworkConnections.ofImmutable((Map)incidentEdgeMap) : UndirectedNetworkConnections.ofImmutable((Map)incidentEdgeMap);
    }

    private static <N, E> Function<E, N> sourceNodeFn(Network<N, E> network) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static <N, E> Function<E, N> targetNodeFn(Network<N, E> network) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static <N, E> Function<E, N> adjacentNodeFn(Network<N, E> network, N node) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

