/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    @Nullable
    private transient Map.Entry<K, V> entrySetCache;

    MapIteratorCache(Map<K, V> backingMap) {
        this.backingMap = (Map)Preconditions.checkNotNull(backingMap);
    }

    @CanIgnoreReturnValue
    public V put(@Nullable K key, @Nullable V value) {
        this.clearCache();
        return this.backingMap.put(key, value);
    }

    @CanIgnoreReturnValue
    public V remove(@Nullable Object key) {
        this.clearCache();
        return this.backingMap.remove(key);
    }

    public void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    public V get(@Nullable Object key) {
        Object value = this.getIfCached(key);
        return (V)(value != null ? value : this.getWithoutCaching(key));
    }

    public final V getWithoutCaching(@Nullable Object key) {
        return this.backingMap.get(key);
    }

    public final boolean containsKey(@Nullable Object key) {
        return this.getIfCached(key) != null || this.backingMap.containsKey(key);
    }

    public final Set<K> unmodifiableKeySet() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected V getIfCached(@Nullable Object key) {
        Map.Entry entry = this.entrySetCache;
        if (entry != null && entry.getKey() == key) {
            return entry.getValue();
        }
        return null;
    }

    protected void clearCache() {
        this.entrySetCache = null;
    }

    static /* synthetic */ Map access$000(MapIteratorCache x0) {
        return x0.backingMap;
    }

    static /* synthetic */ Map.Entry access$102(MapIteratorCache x0, Map.Entry x1) {
        x0.entrySetCache = x1;
        return x0.entrySetCache;
    }
}

