/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import java.util.Map;
import javax.annotation.Nullable;

class MapRetrievalCache<K, V>
extends MapIteratorCache<K, V> {
    @Nullable
    private transient CacheEntry<K, V> cacheEntry1;
    @Nullable
    private transient CacheEntry<K, V> cacheEntry2;

    MapRetrievalCache(Map<K, V> backingMap) {
        super(backingMap);
    }

    public V get(@Nullable Object key) {
        Object value = this.getIfCached(key);
        if (value != null) {
            return (V)value;
        }
        value = this.getWithoutCaching(key);
        if (value != null) {
            this.addToCache(key, value);
        }
        return (V)value;
    }

    protected V getIfCached(@Nullable Object key) {
        Object value = super.getIfCached(key);
        if (value != null) {
            return (V)value;
        }
        CacheEntry entry = this.cacheEntry1;
        if (entry != null && entry.key == key) {
            return (V)entry.value;
        }
        entry = this.cacheEntry2;
        if (entry != null && entry.key == key) {
            this.addToCache(entry);
            return (V)entry.value;
        }
        return null;
    }

    protected void clearCache() {
        super.clearCache();
        this.cacheEntry1 = null;
        this.cacheEntry2 = null;
    }

    private void addToCache(K key, V value) {
        this.addToCache(new CacheEntry(key, value));
    }

    private void addToCache(CacheEntry<K, V> entry) {
        this.cacheEntry2 = this.cacheEntry1;
        this.cacheEntry1 = entry;
    }
}

