/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.BloomFilterStrategies;
import com.google.common.hash.Funnel;
import com.google.common.primitives.SignedBytes;
import com.google.common.primitives.UnsignedBytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public final class BloomFilter<T>
implements Predicate<T>,
Serializable {
    private final BloomFilterStrategies.BitArray bits;
    private final int numHashFunctions;
    private final Funnel<? super T> funnel;
    private final Strategy strategy;

    private BloomFilter(BloomFilterStrategies.BitArray bits, int numHashFunctions, Funnel<? super T> funnel, Strategy strategy) {
        Preconditions.checkArgument((numHashFunctions > 0 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be > 0", (int)numHashFunctions);
        Preconditions.checkArgument((numHashFunctions <= 255 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be <= 255", (int)numHashFunctions);
        this.bits = (BloomFilterStrategies.BitArray)Preconditions.checkNotNull((Object)bits);
        this.numHashFunctions = numHashFunctions;
        this.funnel = (Funnel)Preconditions.checkNotNull(funnel);
        this.strategy = (Strategy)Preconditions.checkNotNull((Object)strategy);
    }

    public BloomFilter<T> copy() {
        return new BloomFilter(this.bits.copy(), this.numHashFunctions, this.funnel, this.strategy);
    }

    public boolean mightContain(T object) {
        return this.strategy.mightContain(object, this.funnel, this.numHashFunctions, this.bits);
    }

    @Deprecated
    public boolean apply(T input) {
        return this.mightContain(input);
    }

    @CanIgnoreReturnValue
    public boolean put(T object) {
        return this.strategy.put(object, this.funnel, this.numHashFunctions, this.bits);
    }

    public double expectedFpp() {
        return Math.pow((double)this.bits.bitCount() / (double)this.bitSize(), this.numHashFunctions);
    }

    @VisibleForTesting
    long bitSize() {
        return this.bits.bitSize();
    }

    public boolean isCompatible(BloomFilter<T> that) {
        Preconditions.checkNotNull(that);
        return this != that && this.numHashFunctions == that.numHashFunctions && this.bitSize() == that.bitSize() && this.strategy.equals(that.strategy) && this.funnel.equals(that.funnel);
    }

    public void putAll(BloomFilter<T> that) {
        Preconditions.checkNotNull(that);
        Preconditions.checkArgument((this != that ? 1 : 0) != 0, (Object)"Cannot combine a BloomFilter with itself.");
        Preconditions.checkArgument((this.numHashFunctions == that.numHashFunctions ? 1 : 0) != 0, (String)"BloomFilters must have the same number of hash functions (%s != %s)", (int)this.numHashFunctions, (int)that.numHashFunctions);
        Preconditions.checkArgument((this.bitSize() == that.bitSize() ? 1 : 0) != 0, (String)"BloomFilters must have the same size underlying bit arrays (%s != %s)", (long)this.bitSize(), (long)that.bitSize());
        Preconditions.checkArgument((boolean)this.strategy.equals(that.strategy), (String)"BloomFilters must have equal strategies (%s != %s)", (Object)this.strategy, (Object)that.strategy);
        Preconditions.checkArgument((boolean)this.funnel.equals(that.funnel), (String)"BloomFilters must have equal funnels (%s != %s)", (Object)this.funnel, (Object)that.funnel);
        this.bits.putAll(that.bits);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BloomFilter) {
            BloomFilter that = (BloomFilter)object;
            return this.numHashFunctions == that.numHashFunctions && this.funnel.equals(that.funnel) && this.bits.equals((Object)that.bits) && this.strategy.equals(that.strategy);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numHashFunctions, this.funnel, this.strategy, this.bits});
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, int expectedInsertions, double fpp) {
        return BloomFilter.create(funnel, (long)expectedInsertions, (double)fpp);
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp) {
        return BloomFilter.create(funnel, (long)expectedInsertions, (double)fpp, (Strategy)BloomFilterStrategies.MURMUR128_MITZ_64);
    }

    @VisibleForTesting
    static <T> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp, Strategy strategy) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument((expectedInsertions >= 0L ? 1 : 0) != 0, (String)"Expected insertions (%s) must be >= 0", (long)expectedInsertions);
        Preconditions.checkArgument((fpp > 0.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be > 0.0", (Object)fpp);
        Preconditions.checkArgument((fpp < 1.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be < 1.0", (Object)fpp);
        Preconditions.checkNotNull((Object)strategy);
        if (expectedInsertions == 0L) {
            expectedInsertions = 1L;
        }
        long numBits = BloomFilter.optimalNumOfBits((long)expectedInsertions, (double)fpp);
        int numHashFunctions = BloomFilter.optimalNumOfHashFunctions((long)expectedInsertions, (long)numBits);
        try {
            return new BloomFilter(new BloomFilterStrategies.BitArray(numBits), numHashFunctions, funnel, strategy);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not create BloomFilter of " + numBits + " bits", e);
        }
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, int expectedInsertions) {
        return BloomFilter.create(funnel, (long)expectedInsertions);
    }

    public static <T> BloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions) {
        return BloomFilter.create(funnel, (long)expectedInsertions, (double)0.03);
    }

    @VisibleForTesting
    static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    @VisibleForTesting
    static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    public void writeTo(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeByte(SignedBytes.checkedCast((long)this.strategy.ordinal()));
        dout.writeByte(UnsignedBytes.checkedCast((long)this.numHashFunctions));
        dout.writeInt(this.bits.data.length);
        for (long value : this.bits.data) {
            dout.writeLong(value);
        }
    }

    public static <T> BloomFilter<T> readFrom(InputStream in, Funnel<T> funnel) throws IOException {
        Preconditions.checkNotNull((Object)in, (Object)"InputStream");
        Preconditions.checkNotNull(funnel, (Object)"Funnel");
        int strategyOrdinal = -1;
        int numHashFunctions = -1;
        int dataLength = -1;
        try {
            DataInputStream din = new DataInputStream(in);
            strategyOrdinal = din.readByte();
            numHashFunctions = UnsignedBytes.toInt((byte)din.readByte());
            dataLength = din.readInt();
            BloomFilterStrategies strategy = BloomFilterStrategies.values()[strategyOrdinal];
            long[] data = new long[dataLength];
            for (int i = 0; i < data.length; ++i) {
                data[i] = din.readLong();
            }
            return new BloomFilter(new BloomFilterStrategies.BitArray(data), numHashFunctions, funnel, (Strategy)strategy);
        }
        catch (RuntimeException e) {
            String message = "Unable to deserialize BloomFilter from InputStream. strategyOrdinal: " + strategyOrdinal + " numHashFunctions: " + numHashFunctions + " dataLength: " + dataLength;
            throw new IOException(message, e);
        }
    }

    static /* synthetic */ BloomFilterStrategies.BitArray access$000(BloomFilter x0) {
        return x0.bits;
    }

    static /* synthetic */ int access$100(BloomFilter x0) {
        return x0.numHashFunctions;
    }

    static /* synthetic */ Funnel access$200(BloomFilter x0) {
        return x0.funnel;
    }

    static /* synthetic */ Strategy access$300(BloomFilter x0) {
        return x0.strategy;
    }
}

