/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.MessageDigestHashFunction;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/*
 * Exception performing whole class analysis ignored.
 */
final class MessageDigestHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final MessageDigest prototype;
    private final int bytes;
    private final boolean supportsClone;
    private final String toString;

    MessageDigestHashFunction(String algorithmName, String toString) {
        this.prototype = MessageDigestHashFunction.getMessageDigest((String)algorithmName);
        this.bytes = this.prototype.getDigestLength();
        this.toString = (String)Preconditions.checkNotNull((Object)toString);
        this.supportsClone = MessageDigestHashFunction.supportsClone((MessageDigest)this.prototype);
    }

    MessageDigestHashFunction(String algorithmName, int bytes, String toString) {
        this.toString = (String)Preconditions.checkNotNull((Object)toString);
        this.prototype = MessageDigestHashFunction.getMessageDigest((String)algorithmName);
        int maxLength = this.prototype.getDigestLength();
        Preconditions.checkArgument((bytes >= 4 && bytes <= maxLength ? 1 : 0) != 0, (String)"bytes (%s) must be >= 4 and < %s", (int)bytes, (int)maxLength);
        this.bytes = bytes;
        this.supportsClone = MessageDigestHashFunction.supportsClone((MessageDigest)this.prototype);
    }

    private static boolean supportsClone(MessageDigest digest) {
        try {
            digest.clone();
            return true;
        }
        catch (CloneNotSupportedException e) {
            return false;
        }
    }

    public int bits() {
        return this.bytes * 8;
    }

    public String toString() {
        return this.toString;
    }

    private static MessageDigest getMessageDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Hasher newHasher() {
        if (this.supportsClone) {
            try {
                return new MessageDigestHasher((MessageDigest)this.prototype.clone(), this.bytes, null);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest((String)this.prototype.getAlgorithm()), this.bytes, null);
    }

    Object writeReplace() {
        return new SerializedForm(this.prototype.getAlgorithm(), this.bytes, this.toString, null);
    }
}

