/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.SipHashFunction;
import java.io.Serializable;
import javax.annotation.Nullable;

final class SipHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final int c;
    private final int d;
    private final long k0;
    private final long k1;
    private static final long serialVersionUID = 0L;

    SipHashFunction(int c, int d, long k0, long k1) {
        Preconditions.checkArgument((c > 0 ? 1 : 0) != 0, (String)"The number of SipRound iterations (c=%s) during Compression must be positive.", (int)c);
        Preconditions.checkArgument((d > 0 ? 1 : 0) != 0, (String)"The number of SipRound iterations (d=%s) during Finalization must be positive.", (int)d);
        this.c = c;
        this.d = d;
        this.k0 = k0;
        this.k1 = k1;
    }

    public int bits() {
        return 64;
    }

    public Hasher newHasher() {
        return new SipHasher(this.c, this.d, this.k0, this.k1);
    }

    public String toString() {
        return "Hashing.sipHash" + this.c + "" + this.d + "(" + this.k0 + ", " + this.k1 + ")";
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof SipHashFunction) {
            SipHashFunction other = (SipHashFunction)object;
            return this.c == other.c && this.d == other.d && this.k0 == other.k0 && this.k1 == other.k1;
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)(this.getClass().hashCode() ^ this.c ^ this.d) ^ this.k0 ^ this.k1);
    }
}

