/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
@GwtIncompatible
public final class Resources {
    private Resources() {
    }

    public static ByteSource asByteSource(URL url) {
        return new UrlByteSource(url, null);
    }

    public static CharSource asCharSource(URL url, Charset charset) {
        return Resources.asByteSource((URL)url).asCharSource(charset);
    }

    public static byte[] toByteArray(URL url) throws IOException {
        return Resources.asByteSource((URL)url).read();
    }

    public static String toString(URL url, Charset charset) throws IOException {
        return Resources.asCharSource((URL)url, (Charset)charset).read();
    }

    @CanIgnoreReturnValue
    public static <T> T readLines(URL url, Charset charset, LineProcessor<T> callback) throws IOException {
        return (T)Resources.asCharSource((URL)url, (Charset)charset).readLines(callback);
    }

    public static List<String> readLines(URL url, Charset charset) throws IOException {
        return (List)Resources.readLines((URL)url, (Charset)charset, (LineProcessor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void copy(URL from, OutputStream to) throws IOException {
        Resources.asByteSource((URL)from).copyTo(to);
    }

    @CanIgnoreReturnValue
    public static URL getResource(String resourceName) {
        ClassLoader loader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)Resources.class.getClassLoader());
        URL url = loader.getResource(resourceName);
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (String)"resource %s not found.", (Object)resourceName);
        return url;
    }

    public static URL getResource(Class<?> contextClass, String resourceName) {
        URL url = contextClass.getResource(resourceName);
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (String)"resource %s relative to %s not found.", (Object)resourceName, (Object)contextClass.getName());
        return url;
    }
}

