/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import com.google.common.math.DoubleUtils;
import com.google.common.math.LongMath;
import com.google.common.math.MathPreconditions;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Iterator;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
public final class DoubleMath {
    private static final double MIN_INT_AS_DOUBLE = -2.147483648E9;
    private static final double MAX_INT_AS_DOUBLE = 2.147483647E9;
    private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
    private static final double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;
    private static final double LN_2 = Math.log(2.0);
    @VisibleForTesting
    static final int MAX_FACTORIAL = 170;
    @VisibleForTesting
    static final double[] everySixteenthFactorial = new double[]{1.0, 2.0922789888E13, 2.631308369336935E35, 1.2413915592536073E61, 1.2688693218588417E89, 7.156945704626381E118, 9.916779348709496E149, 1.974506857221074E182, 3.856204823625804E215, 5.5502938327393044E249, 4.7147236359920616E284};

    @GwtIncompatible
    static double roundIntermediate(double x, RoundingMode mode) {
        if (!DoubleUtils.isFinite((double)x)) {
            throw new ArithmeticException("input is infinite or NaN");
        }
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((boolean)DoubleMath.isMathematicalInteger((double)x));
                return x;
            }
            case 2: {
                if (x >= 0.0 || DoubleMath.isMathematicalInteger((double)x)) {
                    return x;
                }
                return (long)x - 1L;
            }
            case 3: {
                if (x <= 0.0 || DoubleMath.isMathematicalInteger((double)x)) {
                    return x;
                }
                return (long)x + 1L;
            }
            case 4: {
                return x;
            }
            case 5: {
                if (DoubleMath.isMathematicalInteger((double)x)) {
                    return x;
                }
                return (long)x + (long)(x > 0.0 ? 1 : -1);
            }
            case 6: {
                return Math.rint(x);
            }
            case 7: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x + Math.copySign(0.5, x);
                }
                return z;
            }
            case 8: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x;
                }
                return z;
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible
    public static int roundToInt(double x, RoundingMode mode) {
        double z = DoubleMath.roundIntermediate((double)x, (RoundingMode)mode);
        MathPreconditions.checkInRange((boolean)(z > -2.147483649E9 & z < 2.147483648E9));
        return (int)z;
    }

    @GwtIncompatible
    public static long roundToLong(double x, RoundingMode mode) {
        double z = DoubleMath.roundIntermediate((double)x, (RoundingMode)mode);
        MathPreconditions.checkInRange((boolean)(-9.223372036854776E18 - z < 1.0 & z < 9.223372036854776E18));
        return (long)z;
    }

    @GwtIncompatible
    public static BigInteger roundToBigInteger(double x, RoundingMode mode) {
        if (-9.223372036854776E18 - (x = DoubleMath.roundIntermediate((double)x, (RoundingMode)mode)) < 1.0 & x < 9.223372036854776E18) {
            return BigInteger.valueOf((long)x);
        }
        int exponent = Math.getExponent(x);
        long significand = DoubleUtils.getSignificand((double)x);
        BigInteger result = BigInteger.valueOf(significand).shiftLeft(exponent - 52);
        return x < 0.0 ? result.negate() : result;
    }

    @GwtIncompatible
    public static boolean isPowerOfTwo(double x) {
        return x > 0.0 && DoubleUtils.isFinite((double)x) && LongMath.isPowerOfTwo((long)DoubleUtils.getSignificand((double)x));
    }

    public static double log2(double x) {
        return Math.log(x) / LN_2;
    }

    @GwtIncompatible
    public static int log2(double x, RoundingMode mode) {
        boolean increment;
        Preconditions.checkArgument((x > 0.0 && DoubleUtils.isFinite((double)x) ? 1 : 0) != 0, (Object)"x must be positive and finite");
        int exponent = Math.getExponent(x);
        if (!DoubleUtils.isNormal((double)x)) {
            return DoubleMath.log2((double)(x * 4.503599627370496E15), (RoundingMode)mode) - 52;
        }
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((boolean)DoubleMath.isPowerOfTwo((double)x));
            }
            case 2: {
                increment = false;
                break;
            }
            case 3: {
                increment = !DoubleMath.isPowerOfTwo((double)x);
                break;
            }
            case 4: {
                increment = exponent < 0 & !DoubleMath.isPowerOfTwo((double)x);
                break;
            }
            case 5: {
                increment = exponent >= 0 & !DoubleMath.isPowerOfTwo((double)x);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                double xScaled = DoubleUtils.scaleNormalize((double)x);
                increment = xScaled * xScaled > 2.0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? exponent + 1 : exponent;
    }

    @GwtIncompatible
    public static boolean isMathematicalInteger(double x) {
        return DoubleUtils.isFinite((double)x) && (x == 0.0 || 52 - Long.numberOfTrailingZeros(DoubleUtils.getSignificand((double)x)) <= Math.getExponent(x));
    }

    public static double factorial(int n) {
        MathPreconditions.checkNonNegative((String)"n", (int)n);
        if (n > 170) {
            return Double.POSITIVE_INFINITY;
        }
        double accum = 1.0;
        for (int i = 1 + (n & 0xFFFFFFF0); i <= n; ++i) {
            accum *= (double)i;
        }
        return accum * everySixteenthFactorial[n >> 4];
    }

    public static boolean fuzzyEquals(double a, double b, double tolerance) {
        MathPreconditions.checkNonNegative((String)"tolerance", (double)tolerance);
        return Math.copySign(a - b, 1.0) <= tolerance || a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    public static int fuzzyCompare(double a, double b, double tolerance) {
        if (DoubleMath.fuzzyEquals((double)a, (double)b, (double)tolerance)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return Booleans.compare((boolean)Double.isNaN(a), (boolean)Double.isNaN(b));
    }

    @Deprecated
    @GwtIncompatible
    public static double mean(double ... values) {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Cannot take mean of 0 values");
        long count = 1L;
        double mean = DoubleMath.checkFinite((double)values[0]);
        for (int index = 1; index < values.length; ++index) {
            DoubleMath.checkFinite((double)values[index]);
            mean += (values[index] - mean) / (double)(++count);
        }
        return mean;
    }

    @Deprecated
    public static double mean(int ... values) {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Cannot take mean of 0 values");
        long sum = 0L;
        for (int index = 0; index < values.length; ++index) {
            sum += (long)values[index];
        }
        return (double)sum / (double)values.length;
    }

    @Deprecated
    public static double mean(long ... values) {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Cannot take mean of 0 values");
        long count = 1L;
        double mean = values[0];
        for (int index = 1; index < values.length; ++index) {
            mean += ((double)values[index] - mean) / (double)(++count);
        }
        return mean;
    }

    @Deprecated
    @GwtIncompatible
    public static double mean(Iterable<? extends Number> values) {
        return DoubleMath.mean(values.iterator());
    }

    @Deprecated
    @GwtIncompatible
    public static double mean(Iterator<? extends Number> values) {
        Preconditions.checkArgument((boolean)values.hasNext(), (Object)"Cannot take mean of 0 values");
        long count = 1L;
        double mean = DoubleMath.checkFinite((double)values.next().doubleValue());
        while (values.hasNext()) {
            double value = DoubleMath.checkFinite((double)values.next().doubleValue());
            mean += (value - mean) / (double)(++count);
        }
        return mean;
    }

    @GwtIncompatible
    @CanIgnoreReturnValue
    private static double checkFinite(double argument) {
        Preconditions.checkArgument((boolean)DoubleUtils.isFinite((double)argument));
        return argument;
    }

    private DoubleMath() {
    }
}

