/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible
public final class Booleans {
    private Booleans() {
    }

    public static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public static int compare(boolean a, boolean b) {
        return a == b ? 0 : (a ? 1 : -1);
    }

    public static boolean contains(boolean[] array, boolean target) {
        for (boolean value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(boolean[] array, boolean target) {
        return Booleans.indexOf((boolean[])array, (boolean)target, (int)0, (int)array.length);
    }

    private static int indexOf(boolean[] array, boolean target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] array, boolean[] target) {
        Preconditions.checkNotNull((Object)array, (Object)"array");
        Preconditions.checkNotNull((Object)target, (Object)"target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean target) {
        return Booleans.lastIndexOf((boolean[])array, (boolean)target, (int)0, (int)array.length);
    }

    private static int lastIndexOf(boolean[] array, boolean target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static boolean[] concat(boolean[] ... arrays) {
        int length = 0;
        for (boolean[] array : arrays) {
            length += array.length;
        }
        boolean[] result = new boolean[length];
        int pos = 0;
        for (boolean[] array : arrays) {
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
        }
        return result;
    }

    public static boolean[] ensureCapacity(boolean[] array, int minLength, int padding) {
        Preconditions.checkArgument((minLength >= 0 ? 1 : 0) != 0, (String)"Invalid minLength: %s", (int)minLength);
        Preconditions.checkArgument((padding >= 0 ? 1 : 0) != 0, (String)"Invalid padding: %s", (int)padding);
        return array.length < minLength ? Arrays.copyOf(array, minLength + padding) : array;
    }

    public static String join(String separator, boolean ... array) {
        Preconditions.checkNotNull((Object)separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 7);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return builder.toString();
    }

    public static Comparator<boolean[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static boolean[] toArray(Collection<Boolean> collection) {
        if (collection instanceof BooleanArrayAsList) {
            return ((BooleanArrayAsList)collection).toBooleanArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        boolean[] array = new boolean[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Boolean)Preconditions.checkNotNull((Object)boxedArray[i]);
        }
        return array;
    }

    public static List<Boolean> asList(boolean ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new BooleanArrayAsList(backingArray);
    }

    @Beta
    public static int countTrue(boolean ... values) {
        int count = 0;
        for (boolean value : values) {
            if (!value) continue;
            ++count;
        }
        return count;
    }

    static /* synthetic */ int access$000(boolean[] x0, boolean x1, int x2, int x3) {
        return Booleans.indexOf((boolean[])x0, (boolean)x1, (int)x2, (int)x3);
    }

    static /* synthetic */ int access$100(boolean[] x0, boolean x1, int x2, int x3) {
        return Booleans.lastIndexOf((boolean[])x0, (boolean)x1, (int)x2, (int)x3);
    }
}

