/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
public final class Floats {
    public static final int BYTES = 4;

    private Floats() {
    }

    public static int hashCode(float value) {
        return Float.valueOf(value).hashCode();
    }

    public static int compare(float a, float b) {
        return Float.compare(a, b);
    }

    public static boolean isFinite(float value) {
        return Float.NEGATIVE_INFINITY < value & value < Float.POSITIVE_INFINITY;
    }

    public static boolean contains(float[] array, float target) {
        for (float value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(float[] array, float target) {
        return Floats.indexOf((float[])array, (float)target, (int)0, (int)array.length);
    }

    private static int indexOf(float[] array, float target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float[] target) {
        Preconditions.checkNotNull((Object)array, (Object)"array");
        Preconditions.checkNotNull((Object)target, (Object)"target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float target) {
        return Floats.lastIndexOf((float[])array, (float)target, (int)0, (int)array.length);
    }

    private static int lastIndexOf(float[] array, float target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static float min(float ... array) {
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0);
        float min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = Math.min(min, array[i]);
        }
        return min;
    }

    public static float max(float ... array) {
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0);
        float max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = Math.max(max, array[i]);
        }
        return max;
    }

    public static float[] concat(float[] ... arrays) {
        int length = 0;
        for (float[] array : arrays) {
            length += array.length;
        }
        float[] result = new float[length];
        int pos = 0;
        for (float[] array : arrays) {
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
        }
        return result;
    }

    @Beta
    public static Converter<String, Float> stringConverter() {
        return FloatConverter.INSTANCE;
    }

    public static float[] ensureCapacity(float[] array, int minLength, int padding) {
        Preconditions.checkArgument((minLength >= 0 ? 1 : 0) != 0, (String)"Invalid minLength: %s", (int)minLength);
        Preconditions.checkArgument((padding >= 0 ? 1 : 0) != 0, (String)"Invalid padding: %s", (int)padding);
        return array.length < minLength ? Arrays.copyOf(array, minLength + padding) : array;
    }

    public static String join(String separator, float ... array) {
        Preconditions.checkNotNull((Object)separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 12);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return builder.toString();
    }

    public static Comparator<float[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static float[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof FloatArrayAsList) {
            return ((FloatArrayAsList)collection).toFloatArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        float[] array = new float[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull((Object)boxedArray[i])).floatValue();
        }
        return array;
    }

    public static List<Float> asList(float ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new FloatArrayAsList(backingArray);
    }

    @Nullable
    @CheckForNull
    @Beta
    @GwtIncompatible
    public static Float tryParse(String string) {
        if (Doubles.FLOATING_POINT_PATTERN.matcher(string).matches()) {
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static /* synthetic */ int access$000(float[] x0, float x1, int x2, int x3) {
        return Floats.indexOf((float[])x0, (float)x1, (int)x2, (int)x3);
    }

    static /* synthetic */ int access$100(float[] x0, float x1, int x2, int x3) {
        return Floats.lastIndexOf((float[])x0, (float)x1, (int)x2, (int)x3);
    }
}

