/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Comparator;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtIncompatible
public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    public static int toInt(byte value) {
        return value & 0xFF;
    }

    @CanIgnoreReturnValue
    public static byte checkedCast(long value) {
        if (value >> 8 != 0L) {
            throw new IllegalArgumentException("Out of range: " + value);
        }
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > (long)UnsignedBytes.toInt((byte)-1)) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a, byte b) {
        return UnsignedBytes.toInt((byte)a) - UnsignedBytes.toInt((byte)b);
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0);
        int min = UnsignedBytes.toInt((byte)array[0]);
        for (int i = 1; i < array.length; ++i) {
            int next = UnsignedBytes.toInt((byte)array[i]);
            if (next >= min) continue;
            min = next;
        }
        return (byte)min;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0);
        int max = UnsignedBytes.toInt((byte)array[0]);
        for (int i = 1; i < array.length; ++i) {
            int next = UnsignedBytes.toInt((byte)array[i]);
            if (next <= max) continue;
            max = next;
        }
        return (byte)max;
    }

    @Beta
    public static String toString(byte x) {
        return UnsignedBytes.toString((byte)x, (int)10);
    }

    @Beta
    public static String toString(byte x, int radix) {
        Preconditions.checkArgument((radix >= 2 && radix <= 36 ? 1 : 0) != 0, (String)"radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", (int)radix);
        return Integer.toString(UnsignedBytes.toInt((byte)x), radix);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string) {
        return UnsignedBytes.parseUnsignedByte((String)string, (int)10);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string, int radix) {
        int parse = Integer.parseInt((String)Preconditions.checkNotNull((Object)string), radix);
        if (parse >> 8 == 0) {
            return (byte)parse;
        }
        throw new NumberFormatException("out of range: " + parse);
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull((Object)separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * (3 + separator.length()));
        builder.append(UnsignedBytes.toInt((byte)array[0]));
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(UnsignedBytes.toString((byte)array[i]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }
}

