/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeResolver;
import com.google.common.reflect.TypeToken;
import com.google.common.reflect.Types;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public abstract class TypeToken<T>
extends TypeCapture<T>
implements Serializable {
    private final Type runtimeType;
    private transient TypeResolver typeResolver;

    protected TypeToken() {
        this.runtimeType = this.capture();
        Preconditions.checkState((!(this.runtimeType instanceof TypeVariable) ? 1 : 0) != 0, (String)"Cannot construct a TypeToken for a type variable.\nYou probably meant to call new TypeToken<%s>(getClass()) that can resolve the type variable for you.\nIf you do need to create a TypeToken of a type variable, please use TypeToken.of() instead.", (Object)this.runtimeType);
    }

    protected TypeToken(Class<?> declaringClass) {
        Type captured = super.capture();
        this.runtimeType = captured instanceof Class ? captured : TypeToken.of(declaringClass).resolveType((Type)captured).runtimeType;
    }

    private TypeToken(Type type) {
        this.runtimeType = (Type)Preconditions.checkNotNull((Object)type);
    }

    public static <T> TypeToken<T> of(Class<T> type) {
        return new SimpleTypeToken(type);
    }

    public static TypeToken<?> of(Type type) {
        return new SimpleTypeToken(type);
    }

    public final Class<? super T> getRawType() {
        Class rawType;
        Class result = rawType = (Class)this.getRawTypes().iterator().next();
        return result;
    }

    public final Type getType() {
        return this.runtimeType;
    }

    public final <X> TypeToken<T> where(TypeParameter<X> typeParam, TypeToken<X> typeArg) {
        TypeResolver resolver = new TypeResolver().where((Map)ImmutableMap.of((Object)new TypeResolver.TypeVariableKey(typeParam.typeVariable), (Object)typeArg.runtimeType));
        return new SimpleTypeToken(resolver.resolveType(this.runtimeType));
    }

    public final <X> TypeToken<T> where(TypeParameter<X> typeParam, Class<X> typeArg) {
        return this.where(typeParam, TypeToken.of(typeArg));
    }

    public final TypeToken<?> resolveType(Type type) {
        Preconditions.checkNotNull((Object)type);
        TypeResolver resolver = this.typeResolver;
        if (resolver == null) {
            resolver = this.typeResolver = TypeResolver.accordingTo((Type)this.runtimeType);
        }
        return TypeToken.of((Type)resolver.resolveType(type));
    }

    private Type[] resolveInPlace(Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.resolveType(types[i]).getType();
        }
        return types;
    }

    private TypeToken<?> resolveSupertype(Type type) {
        TypeToken supertype = this.resolveType(type);
        supertype.typeResolver = this.typeResolver;
        return supertype;
    }

    @Nullable
    final TypeToken<? super T> getGenericSuperclass() {
        if (this.runtimeType instanceof TypeVariable) {
            return this.boundAsSuperclass(((TypeVariable)this.runtimeType).getBounds()[0]);
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.boundAsSuperclass(((WildcardType)this.runtimeType).getUpperBounds()[0]);
        }
        Type superclass = this.getRawType().getGenericSuperclass();
        if (superclass == null) {
            return null;
        }
        TypeToken superToken = this.resolveSupertype(superclass);
        return superToken;
    }

    @Nullable
    private TypeToken<? super T> boundAsSuperclass(Type bound) {
        TypeToken token = TypeToken.of((Type)bound);
        if (token.getRawType().isInterface()) {
            return null;
        }
        TypeToken superclass = token;
        return superclass;
    }

    final ImmutableList<TypeToken<? super T>> getGenericInterfaces() {
        if (this.runtimeType instanceof TypeVariable) {
            return this.boundsAsInterfaces(((TypeVariable)this.runtimeType).getBounds());
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.boundsAsInterfaces(((WildcardType)this.runtimeType).getUpperBounds());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type interfaceType : this.getRawType().getGenericInterfaces()) {
            TypeToken resolvedInterface = this.resolveSupertype(interfaceType);
            builder.add((Object)resolvedInterface);
        }
        return builder.build();
    }

    private ImmutableList<TypeToken<? super T>> boundsAsInterfaces(Type[] bounds) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type bound : bounds) {
            TypeToken boundType = TypeToken.of((Type)bound);
            if (!boundType.getRawType().isInterface()) continue;
            builder.add((Object)boundType);
        }
        return builder.build();
    }

    public final TypeSet getTypes() {
        return new TypeSet(this);
    }

    public final TypeToken<? super T> getSupertype(Class<? super T> superclass) {
        Preconditions.checkArgument((boolean)this.someRawTypeIsSubclassOf(superclass), (String)"%s is not a super class of %s", superclass, (Object)this);
        if (this.runtimeType instanceof TypeVariable) {
            return this.getSupertypeFromUpperBounds(superclass, ((TypeVariable)this.runtimeType).getBounds());
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.getSupertypeFromUpperBounds(superclass, ((WildcardType)this.runtimeType).getUpperBounds());
        }
        if (superclass.isArray()) {
            return this.getArraySupertype(superclass);
        }
        TypeToken supertype = this.resolveSupertype(TypeToken.toGenericType(superclass).runtimeType);
        return supertype;
    }

    public final TypeToken<? extends T> getSubtype(Class<?> subclass) {
        Preconditions.checkArgument((!(this.runtimeType instanceof TypeVariable) ? 1 : 0) != 0, (String)"Cannot get subtype of type variable <%s>", (Object)this);
        if (this.runtimeType instanceof WildcardType) {
            return this.getSubtypeFromLowerBounds(subclass, ((WildcardType)this.runtimeType).getLowerBounds());
        }
        if (this.isArray()) {
            return this.getArraySubtype(subclass);
        }
        Preconditions.checkArgument((boolean)this.getRawType().isAssignableFrom(subclass), (String)"%s isn't a subclass of %s", subclass, (Object)this);
        Type resolvedTypeArgs = this.resolveTypeArgsForSubclass(subclass);
        TypeToken subtype = TypeToken.of((Type)resolvedTypeArgs);
        return subtype;
    }

    public final boolean isSupertypeOf(TypeToken<?> type) {
        return type.isSubtypeOf(this.getType());
    }

    public final boolean isSupertypeOf(Type type) {
        return TypeToken.of((Type)type).isSubtypeOf(this.getType());
    }

    public final boolean isSubtypeOf(TypeToken<?> type) {
        return this.isSubtypeOf(type.getType());
    }

    public final boolean isSubtypeOf(Type supertype) {
        Preconditions.checkNotNull((Object)supertype);
        if (supertype instanceof WildcardType) {
            return TypeToken.any((Type[])((WildcardType)supertype).getLowerBounds()).isSupertypeOf(this.runtimeType);
        }
        if (this.runtimeType instanceof WildcardType) {
            return TypeToken.any((Type[])((WildcardType)this.runtimeType).getUpperBounds()).isSubtypeOf(supertype);
        }
        if (this.runtimeType instanceof TypeVariable) {
            return this.runtimeType.equals(supertype) || TypeToken.any((Type[])((TypeVariable)this.runtimeType).getBounds()).isSubtypeOf(supertype);
        }
        if (this.runtimeType instanceof GenericArrayType) {
            return TypeToken.of((Type)supertype).isSupertypeOfArray((GenericArrayType)this.runtimeType);
        }
        if (supertype instanceof Class) {
            return this.someRawTypeIsSubclassOf((Class)supertype);
        }
        if (supertype instanceof ParameterizedType) {
            return this.isSubtypeOfParameterizedType((ParameterizedType)supertype);
        }
        if (supertype instanceof GenericArrayType) {
            return this.isSubtypeOfArrayType((GenericArrayType)supertype);
        }
        return false;
    }

    public final boolean isArray() {
        return this.getComponentType() != null;
    }

    public final boolean isPrimitive() {
        return this.runtimeType instanceof Class && ((Class)this.runtimeType).isPrimitive();
    }

    public final TypeToken<T> wrap() {
        if (this.isPrimitive()) {
            Class type = (Class)this.runtimeType;
            return TypeToken.of((Class)Primitives.wrap((Class)type));
        }
        return this;
    }

    private boolean isWrapper() {
        return Primitives.allWrapperTypes().contains(this.runtimeType);
    }

    public final TypeToken<T> unwrap() {
        if (this.isWrapper()) {
            Class type = (Class)this.runtimeType;
            return TypeToken.of((Class)Primitives.unwrap((Class)type));
        }
        return this;
    }

    @Nullable
    public final TypeToken<?> getComponentType() {
        Type componentType = Types.getComponentType((Type)this.runtimeType);
        if (componentType == null) {
            return null;
        }
        return TypeToken.of((Type)componentType);
    }

    public final Invokable<T, Object> method(Method method) {
        Preconditions.checkArgument((boolean)this.someRawTypeIsSubclassOf(method.getDeclaringClass()), (String)"%s not declared by %s", (Object)method, (Object)this);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public final Invokable<T, T> constructor(Constructor<?> constructor) {
        Preconditions.checkArgument((constructor.getDeclaringClass() == this.getRawType() ? 1 : 0) != 0, (String)"%s not declared by %s", constructor, (Object)this.getRawType());
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof TypeToken) {
            TypeToken that = (TypeToken)o;
            return this.runtimeType.equals(that.runtimeType);
        }
        return false;
    }

    public int hashCode() {
        return this.runtimeType.hashCode();
    }

    public String toString() {
        return Types.toString((Type)this.runtimeType);
    }

    protected Object writeReplace() {
        return TypeToken.of((Type)new TypeResolver().resolveType(this.runtimeType));
    }

    @CanIgnoreReturnValue
    final TypeToken<T> rejectTypeVariables() {
        new /* Unavailable Anonymous Inner Class!! */.visit(new Type[]{this.runtimeType});
        return this;
    }

    private boolean someRawTypeIsSubclassOf(Class<?> superclass) {
        for (Class rawType : this.getRawTypes()) {
            if (!superclass.isAssignableFrom(rawType)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubtypeOfParameterizedType(ParameterizedType supertype) {
        Class matchedClass = TypeToken.of((Type)supertype).getRawType();
        if (!this.someRawTypeIsSubclassOf(matchedClass)) {
            return false;
        }
        TypeVariable<Class<T>>[] typeParams = matchedClass.getTypeParameters();
        Type[] toTypeArgs = supertype.getActualTypeArguments();
        for (int i = 0; i < typeParams.length; ++i) {
            if (this.resolveType(typeParams[i]).is(toTypeArgs[i])) continue;
            return false;
        }
        return Modifier.isStatic(((Class)supertype.getRawType()).getModifiers()) || supertype.getOwnerType() == null || this.isOwnedBySubtypeOf(supertype.getOwnerType());
    }

    private boolean isSubtypeOfArrayType(GenericArrayType supertype) {
        if (this.runtimeType instanceof Class) {
            Class fromClass = (Class)this.runtimeType;
            if (!fromClass.isArray()) {
                return false;
            }
            return TypeToken.of(fromClass.getComponentType()).isSubtypeOf(supertype.getGenericComponentType());
        }
        if (this.runtimeType instanceof GenericArrayType) {
            GenericArrayType fromArrayType = (GenericArrayType)this.runtimeType;
            return TypeToken.of((Type)fromArrayType.getGenericComponentType()).isSubtypeOf(supertype.getGenericComponentType());
        }
        return false;
    }

    private boolean isSupertypeOfArray(GenericArrayType subtype) {
        if (this.runtimeType instanceof Class) {
            Class thisClass = (Class)this.runtimeType;
            if (!thisClass.isArray()) {
                return thisClass.isAssignableFrom(Object[].class);
            }
            return TypeToken.of((Type)subtype.getGenericComponentType()).isSubtypeOf(thisClass.getComponentType());
        }
        if (this.runtimeType instanceof GenericArrayType) {
            return TypeToken.of((Type)subtype.getGenericComponentType()).isSubtypeOf(((GenericArrayType)this.runtimeType).getGenericComponentType());
        }
        return false;
    }

    private boolean is(Type formalType) {
        if (this.runtimeType.equals(formalType)) {
            return true;
        }
        if (formalType instanceof WildcardType) {
            return TypeToken.every((Type[])((WildcardType)formalType).getUpperBounds()).isSupertypeOf(this.runtimeType) && TypeToken.every((Type[])((WildcardType)formalType).getLowerBounds()).isSubtypeOf(this.runtimeType);
        }
        return false;
    }

    private static Bounds every(Type[] bounds) {
        return new Bounds(bounds, false);
    }

    private static Bounds any(Type[] bounds) {
        return new Bounds(bounds, true);
    }

    private ImmutableSet<Class<? super T>> getRawTypes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        new /* Unavailable Anonymous Inner Class!! */.visit(new Type[]{this.runtimeType});
        ImmutableSet result = builder.build();
        return result;
    }

    private boolean isOwnedBySubtypeOf(Type supertype) {
        for (TypeToken type : this.getTypes()) {
            Type ownerType = type.getOwnerTypeIfPresent();
            if (ownerType == null || !TypeToken.of((Type)ownerType).isSubtypeOf(supertype)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Type getOwnerTypeIfPresent() {
        if (this.runtimeType instanceof ParameterizedType) {
            return ((ParameterizedType)this.runtimeType).getOwnerType();
        }
        if (this.runtimeType instanceof Class) {
            return ((Class)this.runtimeType).getEnclosingClass();
        }
        return null;
    }

    @VisibleForTesting
    static <T> TypeToken<? extends T> toGenericType(Class<T> cls) {
        Type ownerType;
        if (cls.isArray()) {
            Type arrayOfGenericType = Types.newArrayType((Type)TypeToken.toGenericType(cls.getComponentType()).runtimeType);
            TypeToken result = TypeToken.of((Type)arrayOfGenericType);
            return result;
        }
        Type[] typeParams = cls.getTypeParameters();
        Type type = ownerType = cls.isMemberClass() && !Modifier.isStatic(cls.getModifiers()) ? TypeToken.toGenericType(cls.getEnclosingClass()).runtimeType : null;
        if (typeParams.length > 0 || ownerType != null && ownerType != cls.getEnclosingClass()) {
            TypeToken type2 = TypeToken.of((Type)Types.newParameterizedTypeWithOwner((Type)ownerType, cls, (Type[])typeParams));
            return type2;
        }
        return TypeToken.of(cls);
    }

    private TypeToken<? super T> getSupertypeFromUpperBounds(Class<? super T> supertype, Type[] upperBounds) {
        for (Type upperBound : upperBounds) {
            TypeToken bound = TypeToken.of((Type)upperBound);
            if (!bound.isSubtypeOf(supertype)) continue;
            TypeToken result = bound.getSupertype(supertype);
            return result;
        }
        throw new IllegalArgumentException(supertype + " isn't a super type of " + this);
    }

    private TypeToken<? extends T> getSubtypeFromLowerBounds(Class<?> subclass, Type[] lowerBounds) {
        int i$ = 0;
        Type[] arr$ = lowerBounds;
        int len$ = arr$.length;
        if (i$ < len$) {
            Type lowerBound = arr$[i$];
            TypeToken bound = TypeToken.of((Type)lowerBound);
            return bound.getSubtype(subclass);
        }
        throw new IllegalArgumentException(subclass + " isn't a subclass of " + this);
    }

    private TypeToken<? super T> getArraySupertype(Class<? super T> supertype) {
        TypeToken componentType = (TypeToken)Preconditions.checkNotNull((Object)this.getComponentType(), (String)"%s isn't a super type of %s", supertype, (Object)this);
        TypeToken componentSupertype = componentType.getSupertype(supertype.getComponentType());
        TypeToken result = TypeToken.of((Type)TypeToken.newArrayClassOrGenericArrayType((Type)componentSupertype.runtimeType));
        return result;
    }

    private TypeToken<? extends T> getArraySubtype(Class<?> subclass) {
        TypeToken componentSubtype = this.getComponentType().getSubtype(subclass.getComponentType());
        TypeToken result = TypeToken.of((Type)TypeToken.newArrayClassOrGenericArrayType((Type)componentSubtype.runtimeType));
        return result;
    }

    private Type resolveTypeArgsForSubclass(Class<?> subclass) {
        if (this.runtimeType instanceof Class && (subclass.getTypeParameters().length == 0 || this.getRawType().getTypeParameters().length != 0)) {
            return subclass;
        }
        TypeToken genericSubtype = TypeToken.toGenericType(subclass);
        Type supertypeWithArgsFromSubtype = genericSubtype.getSupertype((Class)this.getRawType()).runtimeType;
        return new TypeResolver().where(supertypeWithArgsFromSubtype, this.runtimeType).resolveType(genericSubtype.runtimeType);
    }

    private static Type newArrayClassOrGenericArrayType(Type componentType) {
        return Types.JavaVersion.JAVA7.newArrayType(componentType);
    }

    static /* synthetic */ Type[] access$000(TypeToken x0, Type[] x1) {
        return x0.resolveInPlace(x1);
    }

    static /* synthetic */ ImmutableSet access$200(TypeToken x0) {
        return x0.getRawTypes();
    }

    static /* synthetic */ Type access$400(TypeToken x0) {
        return x0.runtimeType;
    }
}

