/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@GwtCompatible(emulated=true)
abstract class ImmediateFuture<V>
implements ListenableFuture<V> {
    private static final Logger log = Logger.getLogger(ImmediateFuture.class.getName());

    ImmediateFuture() {
    }

    public void addListener(Runnable listener, Executor executor) {
        Preconditions.checkNotNull((Object)listener, (Object)"Runnable was null.");
        Preconditions.checkNotNull((Object)executor, (Object)"Executor was null.");
        try {
            executor.execute(listener);
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "RuntimeException while executing runnable " + listener + " with executor " + executor, e);
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public abstract V get() throws ExecutionException;

    public V get(long timeout, TimeUnit unit) throws ExecutionException {
        Preconditions.checkNotNull((Object)((Object)unit));
        return (V)this.get();
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return true;
    }
}

