/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SerializingExecutor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

@GwtIncompatible
final class SerializingExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(SerializingExecutor.class.getName());
    private final Executor executor;
    @GuardedBy(value="internalLock")
    private final Deque<Runnable> queue = new ArrayDeque();
    @GuardedBy(value="internalLock")
    private boolean isWorkerRunning = false;
    @GuardedBy(value="internalLock")
    private int suspensions = 0;
    private final Object internalLock = new Object();

    public SerializingExecutor(Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        Object object = this.internalLock;
        synchronized (object) {
            this.queue.add(task);
        }
        this.startQueueWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFirst(Runnable task) {
        Object object = this.internalLock;
        synchronized (object) {
            this.queue.addFirst(task);
        }
        this.startQueueWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.internalLock;
        synchronized (object) {
            ++this.suspensions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.internalLock;
        synchronized (object) {
            Preconditions.checkState((this.suspensions > 0 ? 1 : 0) != 0);
            --this.suspensions;
        }
        this.startQueueWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQueueWorker() {
        Object object = this.internalLock;
        synchronized (object) {
            if (this.queue.peek() == null) {
                return;
            }
            if (this.suspensions > 0) {
                return;
            }
            if (this.isWorkerRunning) {
                return;
            }
            this.isWorkerRunning = true;
        }
        boolean executionRejected = true;
        try {
            this.executor.execute((Runnable)new QueueWorker(this, null));
            executionRejected = false;
        }
        finally {
            if (executionRejected) {
                Object object2 = this.internalLock;
                synchronized (object2) {
                    this.isWorkerRunning = false;
                }
            }
        }
    }

    static /* synthetic */ Object access$100(SerializingExecutor x0) {
        return x0.internalLock;
    }

    static /* synthetic */ boolean access$202(SerializingExecutor x0, boolean x1) {
        x0.isWorkerRunning = x1;
        return x0.isWorkerRunning;
    }

    static /* synthetic */ int access$300(SerializingExecutor x0) {
        return x0.suspensions;
    }

    static /* synthetic */ Deque access$400(SerializingExecutor x0) {
        return x0.queue;
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }
}

