/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckReturnValue;

/*
 * Exception performing whole class analysis ignored.
 */
@CanIgnoreReturnValue
@GwtIncompatible
public final class ThreadFactoryBuilder {
    private String nameFormat = null;
    private Boolean daemon = null;
    private Integer priority = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory backingThreadFactory = null;

    public ThreadFactoryBuilder setNameFormat(String nameFormat) {
        String unused = ThreadFactoryBuilder.format((String)nameFormat, (Object[])new Object[]{0});
        this.nameFormat = nameFormat;
        return this;
    }

    public ThreadFactoryBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder setPriority(int priority) {
        Preconditions.checkArgument((priority >= 1 ? 1 : 0) != 0, (String)"Thread priority (%s) must be >= %s", (int)priority, (int)1);
        Preconditions.checkArgument((priority <= 10 ? 1 : 0) != 0, (String)"Thread priority (%s) must be <= %s", (int)priority, (int)10);
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = (Thread.UncaughtExceptionHandler)Preconditions.checkNotNull((Object)uncaughtExceptionHandler);
        return this;
    }

    public ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        this.backingThreadFactory = (ThreadFactory)Preconditions.checkNotNull((Object)backingThreadFactory);
        return this;
    }

    @CheckReturnValue
    public ThreadFactory build() {
        return ThreadFactoryBuilder.build((ThreadFactoryBuilder)this);
    }

    private static ThreadFactory build(ThreadFactoryBuilder builder) {
        String nameFormat = builder.nameFormat;
        Boolean daemon = builder.daemon;
        Integer priority = builder.priority;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = builder.uncaughtExceptionHandler;
        ThreadFactory backingThreadFactory = builder.backingThreadFactory != null ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        AtomicLong count = nameFormat != null ? new AtomicLong(0L) : null;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    static /* synthetic */ String access$000(String x0, Object[] x1) {
        return ThreadFactoryBuilder.format((String)x0, (Object[])x1);
    }
}

