/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.CertificatePinner;
import okhttp3.internal.Util;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    private final Set<Pin> pins;
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;

    CertificatePinner(Set<Pin> pins, @Nullable CertificateChainCleaner certificateChainCleaner) {
        this.pins = pins;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof CertificatePinner && Util.equal((Object)this.certificateChainCleaner, (Object)((CertificatePinner)other).certificateChainCleaner) && this.pins.equals(((CertificatePinner)other).pins);
    }

    public int hashCode() {
        int result = this.certificateChainCleaner != null ? this.certificateChainCleaner.hashCode() : 0;
        result = 31 * result + this.pins.hashCode();
        return result;
    }

    public void check(String hostname, List<Certificate> peerCertificates) throws SSLPeerUnverifiedException {
        List pins = this.findMatchingPins(hostname);
        if (pins.isEmpty()) {
            return;
        }
        if (this.certificateChainCleaner != null) {
            peerCertificates = this.certificateChainCleaner.clean(peerCertificates, hostname);
        }
        int certsSize = peerCertificates.size();
        for (int c = 0; c < certsSize; ++c) {
            X509Certificate x509Certificate = (X509Certificate)peerCertificates.get(c);
            ByteString sha1 = null;
            ByteString sha256 = null;
            int pinsSize = pins.size();
            for (int p = 0; p < pinsSize; ++p) {
                Pin pin = (Pin)pins.get(p);
                if (pin.hashAlgorithm.equals("sha256/")) {
                    if (sha256 == null) {
                        sha256 = CertificatePinner.sha256((X509Certificate)x509Certificate);
                    }
                    if (!pin.hash.equals((Object)sha256)) continue;
                    return;
                }
                if (pin.hashAlgorithm.equals("sha1/")) {
                    if (sha1 == null) {
                        sha1 = CertificatePinner.sha1((X509Certificate)x509Certificate);
                    }
                    if (!pin.hash.equals((Object)sha1)) continue;
                    return;
                }
                throw new AssertionError();
            }
        }
        StringBuilder message = new StringBuilder().append("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int certsSize2 = peerCertificates.size();
        for (int c = 0; c < certsSize2; ++c) {
            X509Certificate x509Certificate = (X509Certificate)peerCertificates.get(c);
            message.append("\n    ").append(CertificatePinner.pin((Certificate)x509Certificate)).append(": ").append(x509Certificate.getSubjectDN().getName());
        }
        message.append("\n  Pinned certificates for ").append(hostname).append(":");
        int pinsSize = pins.size();
        for (int p = 0; p < pinsSize; ++p) {
            Pin pin = (Pin)pins.get(p);
            message.append("\n    ").append(pin);
        }
        throw new SSLPeerUnverifiedException(message.toString());
    }

    public void check(String hostname, Certificate ... peerCertificates) throws SSLPeerUnverifiedException {
        this.check(hostname, Arrays.asList(peerCertificates));
    }

    List<Pin> findMatchingPins(String hostname) {
        List<Pin> result = Collections.emptyList();
        for (Pin pin : this.pins) {
            if (!pin.matches(hostname)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<Pin>();
            }
            result.add(pin);
        }
        return result;
    }

    CertificatePinner withCertificateChainCleaner(CertificateChainCleaner certificateChainCleaner) {
        return Util.equal((Object)this.certificateChainCleaner, (Object)certificateChainCleaner) ? this : new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public static String pin(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
        }
        return "sha256/" + CertificatePinner.sha256((X509Certificate)((X509Certificate)certificate)).base64();
    }

    static ByteString sha1(X509Certificate x509Certificate) {
        return ByteString.of((byte[])x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static ByteString sha256(X509Certificate x509Certificate) {
        return ByteString.of((byte[])x509Certificate.getPublicKey().getEncoded()).sha256();
    }
}

