/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

public final class MultipartBody
extends RequestBody {
    public static final MediaType MIXED = MediaType.parse((String)"multipart/mixed");
    public static final MediaType ALTERNATIVE = MediaType.parse((String)"multipart/alternative");
    public static final MediaType DIGEST = MediaType.parse((String)"multipart/digest");
    public static final MediaType PARALLEL = MediaType.parse((String)"multipart/parallel");
    public static final MediaType FORM = MediaType.parse((String)"multipart/form-data");
    private static final byte[] COLONSPACE = new byte[]{58, 32};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHDASH = new byte[]{45, 45};
    private final ByteString boundary;
    private final MediaType originalType;
    private final MediaType contentType;
    private final List<Part> parts;
    private long contentLength = -1L;

    MultipartBody(ByteString boundary, MediaType type, List<Part> parts) {
        this.boundary = boundary;
        this.originalType = type;
        this.contentType = MediaType.parse((String)(type + "; boundary=" + boundary.utf8()));
        this.parts = Util.immutableList(parts);
    }

    public MediaType type() {
        return this.originalType;
    }

    public String boundary() {
        return this.boundary.utf8();
    }

    public int size() {
        return this.parts.size();
    }

    public List<Part> parts() {
        return this.parts;
    }

    public Part part(int index) {
        return (Part)this.parts.get(index);
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() throws IOException {
        long result = this.contentLength;
        if (result != -1L) {
            return result;
        }
        this.contentLength = this.writeOrCountBytes(null, true);
        return this.contentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.writeOrCountBytes(sink, false);
    }

    private long writeOrCountBytes(@Nullable BufferedSink sink, boolean countBytes) throws IOException {
        long byteCount = 0L;
        Buffer byteCountBuffer = null;
        if (countBytes) {
            byteCountBuffer = new Buffer();
            sink = byteCountBuffer;
        }
        int partCount = this.parts.size();
        for (int p = 0; p < partCount; ++p) {
            long contentLength;
            MediaType contentType;
            Part part = (Part)this.parts.get(p);
            Headers headers = part.headers;
            RequestBody body = part.body;
            sink.write(DASHDASH);
            sink.write(this.boundary);
            sink.write(CRLF);
            if (headers != null) {
                int headerCount = headers.size();
                for (int h = 0; h < headerCount; ++h) {
                    sink.writeUtf8(headers.name(h)).write(COLONSPACE).writeUtf8(headers.value(h)).write(CRLF);
                }
            }
            if ((contentType = body.contentType()) != null) {
                sink.writeUtf8("Content-Type: ").writeUtf8(contentType.toString()).write(CRLF);
            }
            if ((contentLength = body.contentLength()) != -1L) {
                sink.writeUtf8("Content-Length: ").writeDecimalLong(contentLength).write(CRLF);
            } else if (countBytes) {
                byteCountBuffer.clear();
                return -1L;
            }
            sink.write(CRLF);
            if (countBytes) {
                byteCount += contentLength;
            } else {
                body.writeTo(sink);
            }
            sink.write(CRLF);
        }
        sink.write(DASHDASH);
        sink.write(this.boundary);
        sink.write(DASHDASH);
        sink.write(CRLF);
        if (countBytes) {
            byteCount += byteCountBuffer.size();
            byteCountBuffer.clear();
        }
        return byteCount;
    }

    static StringBuilder appendQuotedString(StringBuilder target, String key) {
        target.append('\"');
        int len = key.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            switch (ch) {
                case '\n': {
                    target.append("%0A");
                    continue block5;
                }
                case '\r': {
                    target.append("%0D");
                    continue block5;
                }
                case '\"': {
                    target.append("%22");
                    continue block5;
                }
                default: {
                    target.append(ch);
                }
            }
        }
        target.append('\"');
        return target;
    }
}

