/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSource;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    @Nullable
    public abstract MediaType contentType();

    public abstract long contentLength();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferedSource source();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] bytes() throws IOException {
        byte[] bytes;
        long contentLength = this.contentLength();
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + contentLength);
        }
        BufferedSource source = this.source();
        try {
            bytes = source.readByteArray();
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
        if (contentLength != -1L && contentLength != (long)bytes.length) {
            throw new IOException("Content-Length (" + contentLength + ") and stream length (" + bytes.length + ") disagree");
        }
        return bytes;
    }

    public final Reader charStream() {
        Reader r = this.reader;
        return r != null ? r : (this.reader = new BomAwareReader(this.source(), this.charset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String string() throws IOException {
        BufferedSource source = this.source();
        try {
            Charset charset = Util.bomAwareCharset((BufferedSource)source, (Charset)this.charset());
            String string = source.readString(charset);
            return string;
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }

    private Charset charset() {
        MediaType contentType = this.contentType();
        return contentType != null ? contentType.charset(Util.UTF_8) : Util.UTF_8;
    }

    @Override
    public void close() {
        Util.closeQuietly((Closeable)this.source());
    }

    public static ResponseBody create(@Nullable MediaType contentType, String content) {
        Charset charset = Util.UTF_8;
        if (contentType != null && (charset = contentType.charset()) == null) {
            charset = Util.UTF_8;
            contentType = MediaType.parse((String)(contentType + "; charset=utf-8"));
        }
        Buffer buffer = new Buffer().writeString(content, charset);
        return ResponseBody.create((MediaType)contentType, (long)buffer.size(), (BufferedSource)buffer);
    }

    public static ResponseBody create(@Nullable MediaType contentType, byte[] content) {
        Buffer buffer = new Buffer().write(content);
        return ResponseBody.create((MediaType)contentType, (long)content.length, (BufferedSource)buffer);
    }

    public static ResponseBody create(@Nullable MediaType contentType, long contentLength, BufferedSource content) {
        if (content == null) {
            throw new NullPointerException("source == null");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

