/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Settings;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;

/*
 * Exception performing whole class analysis ignored.
 */
final class Http2Reader
implements Closeable {
    static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSource source;
    private final ContinuationSource continuation;
    private final boolean client;
    final Hpack.Reader hpackReader;

    Http2Reader(BufferedSource source, boolean client) {
        this.source = source;
        this.client = client;
        this.continuation = new ContinuationSource(this.source);
        this.hpackReader = new Hpack.Reader(4096, (Source)this.continuation);
    }

    public void readConnectionPreface(Handler handler) throws IOException {
        if (this.client) {
            if (!this.nextFrame(true, handler)) {
                throw Http2.ioException((String)"Required SETTINGS preface not received", (Object[])new Object[0]);
            }
        } else {
            ByteString connectionPreface = this.source.readByteString((long)Http2.CONNECTION_PREFACE.size());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Util.format((String)"<< CONNECTION %s", (Object[])new Object[]{connectionPreface.hex()}));
            }
            if (!Http2.CONNECTION_PREFACE.equals((Object)connectionPreface)) {
                throw Http2.ioException((String)"Expected a connection header but was %s", (Object[])new Object[]{connectionPreface.utf8()});
            }
        }
    }

    public boolean nextFrame(boolean requireSettings, Handler handler) throws IOException {
        try {
            this.source.require(9L);
        }
        catch (IOException e) {
            return false;
        }
        int length = Http2Reader.readMedium((BufferedSource)this.source);
        if (length < 0 || length > 16384) {
            throw Http2.ioException((String)"FRAME_SIZE_ERROR: %s", (Object[])new Object[]{length});
        }
        byte type = (byte)(this.source.readByte() & 0xFF);
        if (requireSettings && type != 4) {
            throw Http2.ioException((String)"Expected a SETTINGS frame but was %s", (Object[])new Object[]{type});
        }
        byte flags = (byte)(this.source.readByte() & 0xFF);
        int streamId = this.source.readInt() & Integer.MAX_VALUE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog((boolean)true, (int)streamId, (int)length, (byte)type, (byte)flags));
        }
        switch (type) {
            case 0: {
                this.readData(handler, length, flags, streamId);
                break;
            }
            case 1: {
                this.readHeaders(handler, length, flags, streamId);
                break;
            }
            case 2: {
                this.readPriority(handler, length, flags, streamId);
                break;
            }
            case 3: {
                this.readRstStream(handler, length, flags, streamId);
                break;
            }
            case 4: {
                this.readSettings(handler, length, flags, streamId);
                break;
            }
            case 5: {
                this.readPushPromise(handler, length, flags, streamId);
                break;
            }
            case 6: {
                this.readPing(handler, length, flags, streamId);
                break;
            }
            case 7: {
                this.readGoAway(handler, length, flags, streamId);
                break;
            }
            case 8: {
                this.readWindowUpdate(handler, length, flags, streamId);
                break;
            }
            default: {
                this.source.skip((long)length);
            }
        }
        return true;
    }

    private void readHeaders(Handler handler, int length, byte flags, int streamId) throws IOException {
        short padding;
        if (streamId == 0) {
            throw Http2.ioException((String)"PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", (Object[])new Object[0]);
        }
        boolean endStream = (flags & 1) != 0;
        short s = padding = (flags & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        if ((flags & 0x20) != 0) {
            this.readPriority(handler, streamId);
            length -= 5;
        }
        length = Http2Reader.lengthWithoutPadding((int)length, (byte)flags, (short)padding);
        List headerBlock = this.readHeaderBlock(length, padding, flags, streamId);
        handler.headers(endStream, streamId, -1, headerBlock);
    }

    private List<Header> readHeaderBlock(int length, short padding, byte flags, int streamId) throws IOException {
        this.continuation.length = this.continuation.left = length;
        this.continuation.padding = padding;
        this.continuation.flags = flags;
        this.continuation.streamId = streamId;
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private void readData(Handler handler, int length, byte flags, int streamId) throws IOException {
        boolean gzipped;
        if (streamId == 0) {
            throw Http2.ioException((String)"PROTOCOL_ERROR: TYPE_DATA streamId == 0", (Object[])new Object[0]);
        }
        boolean inFinished = (flags & 1) != 0;
        boolean bl = gzipped = (flags & 0x20) != 0;
        if (gzipped) {
            throw Http2.ioException((String)"PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", (Object[])new Object[0]);
        }
        short padding = (flags & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        length = Http2Reader.lengthWithoutPadding((int)length, (byte)flags, (short)padding);
        handler.data(inFinished, streamId, this.source, length);
        this.source.skip((long)padding);
    }

    private void readPriority(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length != 5) {
            throw Http2.ioException((String)"TYPE_PRIORITY length: %d != 5", (Object[])new Object[]{length});
        }
        if (streamId == 0) {
            throw Http2.ioException((String)"TYPE_PRIORITY streamId == 0", (Object[])new Object[0]);
        }
        this.readPriority(handler, streamId);
    }

    private void readPriority(Handler handler, int streamId) throws IOException {
        int w1 = this.source.readInt();
        boolean exclusive = (w1 & Integer.MIN_VALUE) != 0;
        int streamDependency = w1 & Integer.MAX_VALUE;
        int weight = (this.source.readByte() & 0xFF) + 1;
        handler.priority(streamId, streamDependency, weight, exclusive);
    }

    private void readRstStream(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length != 4) {
            throw Http2.ioException((String)"TYPE_RST_STREAM length: %d != 4", (Object[])new Object[]{length});
        }
        if (streamId == 0) {
            throw Http2.ioException((String)"TYPE_RST_STREAM streamId == 0", (Object[])new Object[0]);
        }
        int errorCodeInt = this.source.readInt();
        ErrorCode errorCode = ErrorCode.fromHttp2((int)errorCodeInt);
        if (errorCode == null) {
            throw Http2.ioException((String)"TYPE_RST_STREAM unexpected error code: %d", (Object[])new Object[]{errorCodeInt});
        }
        handler.rstStream(streamId, errorCode);
    }

    private void readSettings(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (streamId != 0) {
            throw Http2.ioException((String)"TYPE_SETTINGS streamId != 0", (Object[])new Object[0]);
        }
        if ((flags & 1) != 0) {
            if (length != 0) {
                throw Http2.ioException((String)"FRAME_SIZE_ERROR ack frame should be empty!", (Object[])new Object[0]);
            }
            handler.ackSettings();
            return;
        }
        if (length % 6 != 0) {
            throw Http2.ioException((String)"TYPE_SETTINGS length %% 6 != 0: %s", (Object[])new Object[]{length});
        }
        Settings settings = new Settings();
        for (int i = 0; i < length; i += 6) {
            int id = this.source.readShort();
            int value = this.source.readInt();
            switch (id) {
                case 1: {
                    break;
                }
                case 2: {
                    if (value == 0 || value == 1) break;
                    throw Http2.ioException((String)"PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", (Object[])new Object[0]);
                }
                case 3: {
                    id = 4;
                    break;
                }
                case 4: {
                    id = 7;
                    if (value >= 0) break;
                    throw Http2.ioException((String)"PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", (Object[])new Object[0]);
                }
                case 5: {
                    if (value >= 16384 && value <= 0xFFFFFF) break;
                    throw Http2.ioException((String)"PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", (Object[])new Object[]{value});
                }
                case 6: {
                    break;
                }
            }
            settings.set(id, value);
        }
        handler.settings(false, settings);
    }

    private void readPushPromise(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (streamId == 0) {
            throw Http2.ioException((String)"PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", (Object[])new Object[0]);
        }
        short padding = (flags & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        int promisedStreamId = this.source.readInt() & Integer.MAX_VALUE;
        length -= 4;
        length = Http2Reader.lengthWithoutPadding((int)length, (byte)flags, (short)padding);
        List headerBlock = this.readHeaderBlock(length, padding, flags, streamId);
        handler.pushPromise(streamId, promisedStreamId, headerBlock);
    }

    private void readPing(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length != 8) {
            throw Http2.ioException((String)"TYPE_PING length != 8: %s", (Object[])new Object[]{length});
        }
        if (streamId != 0) {
            throw Http2.ioException((String)"TYPE_PING streamId != 0", (Object[])new Object[0]);
        }
        int payload1 = this.source.readInt();
        int payload2 = this.source.readInt();
        boolean ack = (flags & 1) != 0;
        handler.ping(ack, payload1, payload2);
    }

    private void readGoAway(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length < 8) {
            throw Http2.ioException((String)"TYPE_GOAWAY length < 8: %s", (Object[])new Object[]{length});
        }
        if (streamId != 0) {
            throw Http2.ioException((String)"TYPE_GOAWAY streamId != 0", (Object[])new Object[0]);
        }
        int lastStreamId = this.source.readInt();
        int errorCodeInt = this.source.readInt();
        int opaqueDataLength = length - 8;
        ErrorCode errorCode = ErrorCode.fromHttp2((int)errorCodeInt);
        if (errorCode == null) {
            throw Http2.ioException((String)"TYPE_GOAWAY unexpected error code: %d", (Object[])new Object[]{errorCodeInt});
        }
        ByteString debugData = ByteString.EMPTY;
        if (opaqueDataLength > 0) {
            debugData = this.source.readByteString((long)opaqueDataLength);
        }
        handler.goAway(lastStreamId, errorCode, debugData);
    }

    private void readWindowUpdate(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length != 4) {
            throw Http2.ioException((String)"TYPE_WINDOW_UPDATE length !=4: %s", (Object[])new Object[]{length});
        }
        long increment = (long)this.source.readInt() & Integer.MAX_VALUE;
        if (increment == 0L) {
            throw Http2.ioException((String)"windowSizeIncrement was 0", (Object[])new Object[]{increment});
        }
        handler.windowUpdate(streamId, increment);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    static int readMedium(BufferedSource source) throws IOException {
        return (source.readByte() & 0xFF) << 16 | (source.readByte() & 0xFF) << 8 | source.readByte() & 0xFF;
    }

    static int lengthWithoutPadding(int length, byte flags, short padding) throws IOException {
        if ((flags & 8) != 0) {
            --length;
        }
        if (padding > length) {
            throw Http2.ioException((String)"PROTOCOL_ERROR padding %s > remaining length %s", (Object[])new Object[]{padding, length});
        }
        return (short)(length - padding);
    }
}

