/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.OptionalMethod;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;

/*
 * Exception performing whole class analysis ignored.
 */
class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;
    private final CloseGuard closeGuard = CloseGuard.get();

    AndroidPlatform(Class<?> sslParametersClass, OptionalMethod<Socket> setUseSessionTickets, OptionalMethod<Socket> setHostname, OptionalMethod<Socket> getAlpnSelectedProtocol, OptionalMethod<Socket> setAlpnProtocols) {
        this.sslParametersClass = sslParametersClass;
        this.setUseSessionTickets = setUseSessionTickets;
        this.setHostname = setHostname;
        this.getAlpnSelectedProtocol = getAlpnSelectedProtocol;
        this.setAlpnProtocols = setAlpnProtocols;
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        try {
            socket.connect(address, connectTimeout);
        }
        catch (AssertionError e) {
            if (Util.isAndroidGetsocknameError((AssertionError)e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
        catch (SecurityException e) {
            IOException ioException = new IOException("Exception in connect");
            ioException.initCause(e);
            throw ioException;
        }
    }

    public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        X509TrustManager x509TrustManager;
        Object context = AndroidPlatform.readFieldOrNull((Object)sslSocketFactory, (Class)this.sslParametersClass, (String)"sslParameters");
        if (context == null) {
            try {
                Class<?> gmsSslParametersClass = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sslSocketFactory.getClass().getClassLoader());
                context = AndroidPlatform.readFieldOrNull((Object)sslSocketFactory, gmsSslParametersClass, (String)"sslParameters");
            }
            catch (ClassNotFoundException e) {
                return super.trustManager(sslSocketFactory);
            }
        }
        if ((x509TrustManager = (X509TrustManager)AndroidPlatform.readFieldOrNull((Object)context, X509TrustManager.class, (String)"x509TrustManager")) != null) {
            return x509TrustManager;
        }
        return (X509TrustManager)AndroidPlatform.readFieldOrNull((Object)context, X509TrustManager.class, (String)"trustManager");
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        if (hostname != null) {
            this.setUseSessionTickets.invokeOptionalWithoutCheckedException((Object)sslSocket, new Object[]{true});
            this.setHostname.invokeOptionalWithoutCheckedException((Object)sslSocket, new Object[]{hostname});
        }
        if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported((Object)sslSocket)) {
            Object[] parameters = new Object[]{AndroidPlatform.concatLengthPrefixed(protocols)};
            this.setAlpnProtocols.invokeWithoutCheckedException((Object)sslSocket, parameters);
        }
    }

    public String getSelectedProtocol(SSLSocket socket) {
        if (this.getAlpnSelectedProtocol == null) {
            return null;
        }
        if (!this.getAlpnSelectedProtocol.isSupported((Object)socket)) {
            return null;
        }
        byte[] alpnResult = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException((Object)socket, new Object[0]);
        return alpnResult != null ? new String(alpnResult, Util.UTF_8) : null;
    }

    public void log(int level, String message, Throwable t) {
        int logLevel;
        int n = logLevel = level == 5 ? 5 : 3;
        if (t != null) {
            message = message + '\n' + Log.getStackTraceString((Throwable)t);
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = message.indexOf(10, i);
            newline = newline != -1 ? newline : length;
            do {
                end = Math.min(newline, i + 4000);
                Log.println((int)logLevel, (String)"OkHttp", (String)message.substring(i, end));
            } while ((i = end) < newline);
        }
    }

    public Object getStackTraceForCloseable(String closer) {
        return this.closeGuard.createAndOpen(closer);
    }

    public void logCloseableLeak(String message, Object stackTrace) {
        boolean reported = this.closeGuard.warnIfOpen(stackTrace);
        if (!reported) {
            this.log(5, message, null);
        }
    }

    public boolean isCleartextTrafficPermitted(String hostname) {
        try {
            Class<?> networkPolicyClass = Class.forName("android.security.NetworkSecurityPolicy");
            Method getInstanceMethod = networkPolicyClass.getMethod("getInstance", new Class[0]);
            Object networkSecurityPolicy = getInstanceMethod.invoke(null, new Object[0]);
            Method isCleartextTrafficPermittedMethod = networkPolicyClass.getMethod("isCleartextTrafficPermitted", String.class);
            return (Boolean)isCleartextTrafficPermittedMethod.invoke(networkSecurityPolicy, hostname);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return super.isCleartextTrafficPermitted(hostname);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new AssertionError();
        }
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        try {
            Class<?> extensionsClass = Class.forName("android.net.http.X509TrustManagerExtensions");
            Constructor<?> constructor = extensionsClass.getConstructor(X509TrustManager.class);
            Object extensions = constructor.newInstance(trustManager);
            Method checkServerTrusted = extensionsClass.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
            return new AndroidCertificateChainCleaner(extensions, checkServerTrusted);
        }
        catch (Exception e) {
            return super.buildCertificateChainCleaner(trustManager);
        }
    }

    public static Platform buildIfSupported() {
        try {
            Class<?> sslParametersClass;
            try {
                sslParametersClass = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            }
            catch (ClassNotFoundException e) {
                sslParametersClass = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            OptionalMethod setUseSessionTickets = new OptionalMethod(null, "setUseSessionTickets", new Class[]{Boolean.TYPE});
            OptionalMethod setHostname = new OptionalMethod(null, "setHostname", new Class[]{String.class});
            OptionalMethod getAlpnSelectedProtocol = null;
            OptionalMethod setAlpnProtocols = null;
            try {
                Class.forName("android.net.Network");
                getAlpnSelectedProtocol = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                setAlpnProtocols = new OptionalMethod(null, "setAlpnProtocols", new Class[]{byte[].class});
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return new AndroidPlatform(sslParametersClass, setUseSessionTickets, setHostname, getAlpnSelectedProtocol, setAlpnProtocols);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

