/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import java.util.Random;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketWriter;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Sink;

final class WebSocketWriter {
    final boolean isClient;
    final Random random;
    final BufferedSink sink;
    boolean writerClosed;
    final Buffer buffer = new Buffer();
    final FrameSink frameSink = new FrameSink(this);
    boolean activeWriter;
    final byte[] maskKey;
    final byte[] maskBuffer;

    WebSocketWriter(boolean isClient, BufferedSink sink, Random random) {
        if (sink == null) {
            throw new NullPointerException("sink == null");
        }
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        this.isClient = isClient;
        this.sink = sink;
        this.random = random;
        this.maskKey = isClient ? new byte[4] : null;
        this.maskBuffer = isClient ? new byte[8192] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePing(ByteString payload) throws IOException {
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            this.writeControlFrameSynchronized(9, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePong(ByteString payload) throws IOException {
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            this.writeControlFrameSynchronized(10, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClose(int code, ByteString reason) throws IOException {
        ByteString payload = ByteString.EMPTY;
        if (code != 0 || reason != null) {
            if (code != 0) {
                WebSocketProtocol.validateCloseCode((int)code);
            }
            Buffer buffer = new Buffer();
            buffer.writeShort(code);
            if (reason != null) {
                buffer.write(reason);
            }
            payload = buffer.readByteString();
        }
        WebSocketWriter webSocketWriter = this;
        synchronized (webSocketWriter) {
            try {
                this.writeControlFrameSynchronized(8, payload);
            }
            finally {
                this.writerClosed = true;
            }
        }
    }

    private void writeControlFrameSynchronized(int opcode, ByteString payload) throws IOException {
        assert (Thread.holdsLock(this));
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int length = payload.size();
        if ((long)length > 125L) {
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        int b0 = 0x80 | opcode;
        this.sink.writeByte(b0);
        int b1 = length;
        if (this.isClient) {
            this.sink.writeByte(b1 |= 0x80);
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            byte[] bytes = payload.toByteArray();
            WebSocketProtocol.toggleMask((byte[])bytes, (long)bytes.length, (byte[])this.maskKey, (long)0L);
            this.sink.write(bytes);
        } else {
            this.sink.writeByte(b1);
            this.sink.write(payload);
        }
        this.sink.flush();
    }

    Sink newMessageSink(int formatOpcode, long contentLength) {
        if (this.activeWriter) {
            throw new IllegalStateException("Another message writer is active. Did you call close()?");
        }
        this.activeWriter = true;
        this.frameSink.formatOpcode = formatOpcode;
        this.frameSink.contentLength = contentLength;
        this.frameSink.isFirstFrame = true;
        this.frameSink.closed = false;
        return this.frameSink;
    }

    void writeMessageFrameSynchronized(int formatOpcode, long byteCount, boolean isFirstFrame, boolean isFinal) throws IOException {
        int b0;
        assert (Thread.holdsLock(this));
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n = b0 = isFirstFrame ? formatOpcode : 0;
        if (isFinal) {
            b0 |= 0x80;
        }
        this.sink.writeByte(b0);
        int b1 = 0;
        if (this.isClient) {
            b1 |= 0x80;
        }
        if (byteCount <= 125L) {
            this.sink.writeByte(b1 |= (int)byteCount);
        } else if (byteCount <= 65535L) {
            this.sink.writeByte(b1 |= 0x7E);
            this.sink.writeShort((int)byteCount);
        } else {
            this.sink.writeByte(b1 |= 0x7F);
            this.sink.writeLong(byteCount);
        }
        if (this.isClient) {
            int read;
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            for (long written = 0L; written < byteCount; written += (long)read) {
                int toRead = (int)Math.min(byteCount, (long)this.maskBuffer.length);
                read = this.buffer.read(this.maskBuffer, 0, toRead);
                if (read == -1) {
                    throw new AssertionError();
                }
                WebSocketProtocol.toggleMask((byte[])this.maskBuffer, (long)read, (byte[])this.maskKey, (long)written);
                this.sink.write(this.maskBuffer, 0, read);
            }
        } else {
            this.sink.write(this.buffer, byteCount);
        }
        this.sink.emit();
    }
}

