/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okio.AsyncTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;

/*
 * Exception performing whole class analysis ignored.
 */
public class AsyncTimeout
extends Timeout {
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final long IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    @Nullable
    static AsyncTimeout head;
    private boolean inQueue;
    @Nullable
    private AsyncTimeout next;
    private long timeoutAt;

    public final void enter() {
        if (this.inQueue) {
            throw new IllegalStateException("Unbalanced enter/exit");
        }
        long timeoutNanos = this.timeoutNanos();
        boolean hasDeadline = this.hasDeadline();
        if (timeoutNanos == 0L && !hasDeadline) {
            return;
        }
        this.inQueue = true;
        AsyncTimeout.scheduleTimeout((AsyncTimeout)this, (long)timeoutNanos, (boolean)hasDeadline);
    }

    private static synchronized void scheduleTimeout(AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
        if (head == null) {
            head = new AsyncTimeout();
            new Watchdog().start();
        }
        long now = System.nanoTime();
        if (timeoutNanos != 0L && hasDeadline) {
            node.timeoutAt = now + Math.min(timeoutNanos, node.deadlineNanoTime() - now);
        } else if (timeoutNanos != 0L) {
            node.timeoutAt = now + timeoutNanos;
        } else if (hasDeadline) {
            node.timeoutAt = node.deadlineNanoTime();
        } else {
            throw new AssertionError();
        }
        long remainingNanos = node.remainingNanos(now);
        AsyncTimeout prev = head;
        while (true) {
            if (prev.next == null || remainingNanos < prev.next.remainingNanos(now)) {
                node.next = prev.next;
                prev.next = node;
                if (prev != head) break;
                AsyncTimeout.class.notify();
                break;
            }
            prev = prev.next;
        }
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout((AsyncTimeout)this);
    }

    private static synchronized boolean cancelScheduledTimeout(AsyncTimeout node) {
        AsyncTimeout prev = head;
        while (prev != null) {
            if (prev.next == node) {
                prev.next = node.next;
                node.next = null;
                return false;
            }
            prev = prev.next;
        }
        return true;
    }

    private long remainingNanos(long now) {
        return this.timeoutAt - now;
    }

    protected void timedOut() {
    }

    public final Sink sink(Sink sink) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public final Source source(Source source) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    final void exit(boolean throwOnTimeout) throws IOException {
        boolean timedOut = this.exit();
        if (timedOut && throwOnTimeout) {
            throw this.newTimeoutException(null);
        }
    }

    final IOException exit(IOException cause) throws IOException {
        if (!this.exit()) {
            return cause;
        }
        return this.newTimeoutException(cause);
    }

    protected IOException newTimeoutException(@Nullable IOException cause) {
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    @Nullable
    static AsyncTimeout awaitTimeout() throws InterruptedException {
        AsyncTimeout node = AsyncTimeout.head.next;
        if (node == null) {
            long startNanos = System.nanoTime();
            AsyncTimeout.class.wait(IDLE_TIMEOUT_MILLIS);
            return AsyncTimeout.head.next == null && System.nanoTime() - startNanos >= IDLE_TIMEOUT_NANOS ? head : null;
        }
        long waitNanos = node.remainingNanos(System.nanoTime());
        if (waitNanos > 0L) {
            long waitMillis = waitNanos / 1000000L;
            AsyncTimeout.class.wait(waitMillis, (int)(waitNanos -= waitMillis * 1000000L));
            return null;
        }
        AsyncTimeout.head.next = node.next;
        node.next = null;
        return node;
    }
}

