/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import okio.AsyncTimeout;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.RealBufferedSink;
import okio.RealBufferedSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Okio {
    static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        return new RealBufferedSink(sink);
    }

    public static Sink sink(OutputStream out) {
        return Okio.sink((OutputStream)out, (Timeout)new Timeout());
    }

    private static Sink sink(OutputStream out, Timeout timeout) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Sink sink(Socket socket) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("socket == null");
        }
        AsyncTimeout timeout = Okio.timeout((Socket)socket);
        Sink sink = Okio.sink((OutputStream)socket.getOutputStream(), (Timeout)timeout);
        return timeout.sink(sink);
    }

    public static Source source(InputStream in) {
        return Okio.source((InputStream)in, (Timeout)new Timeout());
    }

    private static Source source(InputStream in, Timeout timeout) {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Source source(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.source((InputStream)new FileInputStream(file));
    }

    @IgnoreJRERequirement
    public static Source source(Path path, OpenOption ... options) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.source((InputStream)Files.newInputStream(path, options));
    }

    public static Sink sink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink((OutputStream)new FileOutputStream(file));
    }

    public static Sink appendingSink(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink((OutputStream)new FileOutputStream(file, true));
    }

    @IgnoreJRERequirement
    public static Sink sink(Path path, OpenOption ... options) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.sink((OutputStream)Files.newOutputStream(path, options));
    }

    public static Sink blackhole() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Source source(Socket socket) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("socket == null");
        }
        AsyncTimeout timeout = Okio.timeout((Socket)socket);
        Source source = Okio.source((InputStream)socket.getInputStream(), (Timeout)timeout);
        return timeout.source(source);
    }

    private static AsyncTimeout timeout(Socket socket) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static boolean isAndroidGetsocknameError(AssertionError e) {
        return ((Throwable)((Object)e)).getCause() != null && ((Throwable)((Object)e)).getMessage() != null && ((Throwable)((Object)e)).getMessage().contains("getsockname failed");
    }
}

