/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DigestUtils {
    private static final int STREAM_BUFFER_LENGTH = 1024;
    private final MessageDigest messageDigest;

    public static byte[] digest(MessageDigest messageDigest, byte[] data) {
        return messageDigest.digest(data);
    }

    public static byte[] digest(MessageDigest messageDigest, ByteBuffer data) {
        messageDigest.update(data);
        return messageDigest.digest();
    }

    public static byte[] digest(MessageDigest messageDigest, File data) throws IOException {
        return DigestUtils.updateDigest((MessageDigest)messageDigest, (File)data).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, InputStream data) throws IOException {
        return DigestUtils.updateDigest((MessageDigest)messageDigest, (InputStream)data).digest();
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MessageDigest getDigest(String algorithm, MessageDigest defaultMessageDigest) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            return defaultMessageDigest;
        }
    }

    public static MessageDigest getMd2Digest() {
        return DigestUtils.getDigest((String)"MD2");
    }

    public static MessageDigest getMd5Digest() {
        return DigestUtils.getDigest((String)"MD5");
    }

    public static MessageDigest getSha1Digest() {
        return DigestUtils.getDigest((String)"SHA-1");
    }

    public static MessageDigest getSha256Digest() {
        return DigestUtils.getDigest((String)"SHA-256");
    }

    public static MessageDigest getSha3_224Digest() {
        return DigestUtils.getDigest((String)"SHA3-224");
    }

    public static MessageDigest getSha3_256Digest() {
        return DigestUtils.getDigest((String)"SHA3-256");
    }

    public static MessageDigest getSha3_384Digest() {
        return DigestUtils.getDigest((String)"SHA3-384");
    }

    public static MessageDigest getSha3_512Digest() {
        return DigestUtils.getDigest((String)"SHA3-512");
    }

    public static MessageDigest getSha384Digest() {
        return DigestUtils.getDigest((String)"SHA-384");
    }

    public static MessageDigest getSha512Digest() {
        return DigestUtils.getDigest((String)"SHA-512");
    }

    @Deprecated
    public static MessageDigest getShaDigest() {
        return DigestUtils.getSha1Digest();
    }

    public static boolean isAvailable(String messageDigestAlgorithm) {
        return DigestUtils.getDigest((String)messageDigestAlgorithm, null) != null;
    }

    public static byte[] md2(byte[] data) {
        return DigestUtils.getMd2Digest().digest(data);
    }

    public static byte[] md2(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getMd2Digest(), (InputStream)data);
    }

    public static byte[] md2(String data) {
        return DigestUtils.md2((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String md2Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.md2((byte[])data));
    }

    public static String md2Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.md2((InputStream)data));
    }

    public static String md2Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.md2((String)data));
    }

    public static byte[] md5(byte[] data) {
        return DigestUtils.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getMd5Digest(), (InputStream)data);
    }

    public static byte[] md5(String data) {
        return DigestUtils.md5((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String md5Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.md5((byte[])data));
    }

    public static String md5Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.md5((InputStream)data));
    }

    public static String md5Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.md5((String)data));
    }

    @Deprecated
    public static byte[] sha(byte[] data) {
        return DigestUtils.sha1((byte[])data);
    }

    @Deprecated
    public static byte[] sha(InputStream data) throws IOException {
        return DigestUtils.sha1((InputStream)data);
    }

    @Deprecated
    public static byte[] sha(String data) {
        return DigestUtils.sha1((String)data);
    }

    public static byte[] sha1(byte[] data) {
        return DigestUtils.getSha1Digest().digest(data);
    }

    public static byte[] sha1(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getSha1Digest(), (InputStream)data);
    }

    public static byte[] sha1(String data) {
        return DigestUtils.sha1((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String sha1Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha1((byte[])data));
    }

    public static String sha1Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.sha1((InputStream)data));
    }

    public static String sha1Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha1((String)data));
    }

    public static byte[] sha256(byte[] data) {
        return DigestUtils.getSha256Digest().digest(data);
    }

    public static byte[] sha256(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getSha256Digest(), (InputStream)data);
    }

    public static byte[] sha256(String data) {
        return DigestUtils.sha256((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String sha256Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha256((byte[])data));
    }

    public static String sha256Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.sha256((InputStream)data));
    }

    public static String sha256Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha256((String)data));
    }

    public static byte[] sha3_224(byte[] data) {
        return DigestUtils.getSha3_224Digest().digest(data);
    }

    public static byte[] sha3_224(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getSha3_224Digest(), (InputStream)data);
    }

    public static byte[] sha3_224(String data) {
        return DigestUtils.sha3_224((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String sha3_224Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_224((String)data));
    }

    public static byte[] sha3_256(byte[] data) {
        return DigestUtils.getSha3_256Digest().digest(data);
    }

    public static byte[] sha3_256(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getSha3_256Digest(), (InputStream)data);
    }

    public static byte[] sha3_256(String data) {
        return DigestUtils.sha3_256((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String sha3_256Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_256((String)data));
    }

    public static byte[] sha3_384(byte[] data) {
        return DigestUtils.getSha3_384Digest().digest(data);
    }

    public static byte[] sha3_384(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getSha3_384Digest(), (InputStream)data);
    }

    public static byte[] sha3_384(String data) {
        return DigestUtils.sha3_384((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String sha3_384Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_384((String)data));
    }

    public static byte[] sha3_512(byte[] data) {
        return DigestUtils.getSha3_512Digest().digest(data);
    }

    public static byte[] sha3_512(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getSha3_512Digest(), (InputStream)data);
    }

    public static byte[] sha3_512(String data) {
        return DigestUtils.sha3_512((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String sha3_512Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_512((String)data));
    }

    public static byte[] sha384(byte[] data) {
        return DigestUtils.getSha384Digest().digest(data);
    }

    public static byte[] sha384(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getSha384Digest(), (InputStream)data);
    }

    public static byte[] sha384(String data) {
        return DigestUtils.sha384((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String sha384Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha384((byte[])data));
    }

    public static String sha384Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.sha384((InputStream)data));
    }

    public static String sha384Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha384((String)data));
    }

    public static byte[] sha512(byte[] data) {
        return DigestUtils.getSha512Digest().digest(data);
    }

    public static byte[] sha512(InputStream data) throws IOException {
        return DigestUtils.digest((MessageDigest)DigestUtils.getSha512Digest(), (InputStream)data);
    }

    public static byte[] sha512(String data) {
        return DigestUtils.sha512((byte[])StringUtils.getBytesUtf8((String)data));
    }

    public static String sha512Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha512((byte[])data));
    }

    public static String sha3_224Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_224((byte[])data));
    }

    public static String sha3_256Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_256((byte[])data));
    }

    public static String sha3_384Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_384((byte[])data));
    }

    public static String sha3_512Hex(byte[] data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_512((byte[])data));
    }

    public static String sha512Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.sha512((InputStream)data));
    }

    public static String sha3_224Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_224((InputStream)data));
    }

    public static String sha3_256Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_256((InputStream)data));
    }

    public static String sha3_384Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_384((InputStream)data));
    }

    public static String sha3_512Hex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])DigestUtils.sha3_512((InputStream)data));
    }

    public static String sha512Hex(String data) {
        return Hex.encodeHexString((byte[])DigestUtils.sha512((String)data));
    }

    @Deprecated
    public static String shaHex(byte[] data) {
        return DigestUtils.sha1Hex((byte[])data);
    }

    @Deprecated
    public static String shaHex(InputStream data) throws IOException {
        return DigestUtils.sha1Hex((InputStream)data);
    }

    @Deprecated
    public static String shaHex(String data) {
        return DigestUtils.sha1Hex((String)data);
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, byte[] valueToDigest) {
        messageDigest.update(valueToDigest);
        return messageDigest;
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, ByteBuffer valueToDigest) {
        messageDigest.update(valueToDigest);
        return messageDigest;
    }

    public static MessageDigest updateDigest(MessageDigest digest, File data) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(data));){
            MessageDigest messageDigest = DigestUtils.updateDigest((MessageDigest)digest, (InputStream)stream);
            return messageDigest;
        }
    }

    public static MessageDigest updateDigest(MessageDigest digest, InputStream data) throws IOException {
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return digest;
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, String valueToDigest) {
        messageDigest.update(StringUtils.getBytesUtf8((String)valueToDigest));
        return messageDigest;
    }

    @Deprecated
    public DigestUtils() {
        this.messageDigest = null;
    }

    public DigestUtils(MessageDigest digest) {
        this.messageDigest = digest;
    }

    public DigestUtils(String name) {
        this(DigestUtils.getDigest((String)name));
    }

    public byte[] digest(byte[] data) {
        return DigestUtils.updateDigest((MessageDigest)this.messageDigest, (byte[])data).digest();
    }

    public byte[] digest(ByteBuffer data) {
        return DigestUtils.updateDigest((MessageDigest)this.messageDigest, (ByteBuffer)data).digest();
    }

    public byte[] digest(File data) throws IOException {
        return DigestUtils.updateDigest((MessageDigest)this.messageDigest, (File)data).digest();
    }

    public byte[] digest(InputStream data) throws IOException {
        return DigestUtils.updateDigest((MessageDigest)this.messageDigest, (InputStream)data).digest();
    }

    public byte[] digest(String data) {
        return DigestUtils.updateDigest((MessageDigest)this.messageDigest, (String)data).digest();
    }

    public String digestAsHex(byte[] data) {
        return Hex.encodeHexString((byte[])this.digest(data));
    }

    public String digestAsHex(ByteBuffer data) {
        return Hex.encodeHexString((byte[])this.digest(data));
    }

    public String digestAsHex(File data) throws IOException {
        return Hex.encodeHexString((byte[])this.digest(data));
    }

    public String digestAsHex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])this.digest(data));
    }

    public String digestAsHex(String data) {
        return Hex.encodeHexString((byte[])this.digest(data));
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }
}

