/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.digest.B64;
import org.apache.commons.codec.digest.DigestUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Sha2Crypt {
    private static final int ROUNDS_DEFAULT = 5000;
    private static final int ROUNDS_MAX = 999999999;
    private static final int ROUNDS_MIN = 1000;
    private static final String ROUNDS_PREFIX = "rounds=";
    private static final int SHA256_BLOCKSIZE = 32;
    static final String SHA256_PREFIX = "$5$";
    private static final int SHA512_BLOCKSIZE = 64;
    static final String SHA512_PREFIX = "$6$";
    private static final Pattern SALT_PATTERN = Pattern.compile("^\\$([56])\\$(rounds=(\\d+)\\$)?([\\.\\/a-zA-Z0-9]{1,16}).*");

    public static String sha256Crypt(byte[] keyBytes) {
        return Sha2Crypt.sha256Crypt((byte[])keyBytes, null);
    }

    public static String sha256Crypt(byte[] keyBytes, String salt) {
        if (salt == null) {
            salt = "$5$" + B64.getRandomSalt((int)8);
        }
        return Sha2Crypt.sha2Crypt((byte[])keyBytes, (String)salt, (String)"$5$", (int)32, (String)"SHA-256");
    }

    public static String sha256Crypt(byte[] keyBytes, String salt, Random random) {
        if (salt == null) {
            salt = "$5$" + B64.getRandomSalt((int)8, (Random)random);
        }
        return Sha2Crypt.sha2Crypt((byte[])keyBytes, (String)salt, (String)"$5$", (int)32, (String)"SHA-256");
    }

    private static String sha2Crypt(byte[] keyBytes, String salt, String saltPrefix, int blocksize, String algorithm) {
        int cp;
        int cnt;
        int keyLen = keyBytes.length;
        int rounds = 5000;
        boolean roundsCustom = false;
        if (salt == null) {
            throw new IllegalArgumentException("Salt must not be null");
        }
        Matcher m = SALT_PATTERN.matcher(salt);
        if (!m.find()) {
            throw new IllegalArgumentException("Invalid salt value: " + salt);
        }
        if (m.group(3) != null) {
            rounds = Integer.parseInt(m.group(3));
            rounds = Math.max(1000, Math.min(999999999, rounds));
            roundsCustom = true;
        }
        String saltString = m.group(4);
        byte[] saltBytes = saltString.getBytes(Charsets.UTF_8);
        int saltLen = saltBytes.length;
        MessageDigest ctx = DigestUtils.getDigest((String)algorithm);
        ctx.update(keyBytes);
        ctx.update(saltBytes);
        MessageDigest altCtx = DigestUtils.getDigest((String)algorithm);
        altCtx.update(keyBytes);
        altCtx.update(saltBytes);
        altCtx.update(keyBytes);
        byte[] altResult = altCtx.digest();
        for (cnt = keyBytes.length; cnt > blocksize; cnt -= blocksize) {
            ctx.update(altResult, 0, blocksize);
        }
        ctx.update(altResult, 0, cnt);
        for (cnt = keyBytes.length; cnt > 0; cnt >>= 1) {
            if ((cnt & 1) != 0) {
                ctx.update(altResult, 0, blocksize);
                continue;
            }
            ctx.update(keyBytes);
        }
        altResult = ctx.digest();
        altCtx = DigestUtils.getDigest((String)algorithm);
        for (int i = 1; i <= keyLen; ++i) {
            altCtx.update(keyBytes);
        }
        byte[] tempResult = altCtx.digest();
        byte[] pBytes = new byte[keyLen];
        for (cp = 0; cp < keyLen - blocksize; cp += blocksize) {
            System.arraycopy(tempResult, 0, pBytes, cp, blocksize);
        }
        System.arraycopy(tempResult, 0, pBytes, cp, keyLen - cp);
        altCtx = DigestUtils.getDigest((String)algorithm);
        for (int i = 1; i <= 16 + (altResult[0] & 0xFF); ++i) {
            altCtx.update(saltBytes);
        }
        tempResult = altCtx.digest();
        byte[] sBytes = new byte[saltLen];
        for (cp = 0; cp < saltLen - blocksize; cp += blocksize) {
            System.arraycopy(tempResult, 0, sBytes, cp, blocksize);
        }
        System.arraycopy(tempResult, 0, sBytes, cp, saltLen - cp);
        for (int i = 0; i <= rounds - 1; ++i) {
            ctx = DigestUtils.getDigest((String)algorithm);
            if ((i & 1) != 0) {
                ctx.update(pBytes, 0, keyLen);
            } else {
                ctx.update(altResult, 0, blocksize);
            }
            if (i % 3 != 0) {
                ctx.update(sBytes, 0, saltLen);
            }
            if (i % 7 != 0) {
                ctx.update(pBytes, 0, keyLen);
            }
            if ((i & 1) != 0) {
                ctx.update(altResult, 0, blocksize);
            } else {
                ctx.update(pBytes, 0, keyLen);
            }
            altResult = ctx.digest();
        }
        StringBuilder buffer = new StringBuilder(saltPrefix);
        if (roundsCustom) {
            buffer.append("rounds=");
            buffer.append(rounds);
            buffer.append("$");
        }
        buffer.append(saltString);
        buffer.append("$");
        if (blocksize == 32) {
            B64.b64from24bit((byte)altResult[0], (byte)altResult[10], (byte)altResult[20], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[21], (byte)altResult[1], (byte)altResult[11], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[12], (byte)altResult[22], (byte)altResult[2], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[3], (byte)altResult[13], (byte)altResult[23], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[24], (byte)altResult[4], (byte)altResult[14], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[15], (byte)altResult[25], (byte)altResult[5], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[6], (byte)altResult[16], (byte)altResult[26], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[27], (byte)altResult[7], (byte)altResult[17], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[18], (byte)altResult[28], (byte)altResult[8], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[9], (byte)altResult[19], (byte)altResult[29], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)0, (byte)altResult[31], (byte)altResult[30], (int)3, (StringBuilder)buffer);
        } else {
            B64.b64from24bit((byte)altResult[0], (byte)altResult[21], (byte)altResult[42], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[22], (byte)altResult[43], (byte)altResult[1], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[44], (byte)altResult[2], (byte)altResult[23], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[3], (byte)altResult[24], (byte)altResult[45], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[25], (byte)altResult[46], (byte)altResult[4], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[47], (byte)altResult[5], (byte)altResult[26], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[6], (byte)altResult[27], (byte)altResult[48], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[28], (byte)altResult[49], (byte)altResult[7], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[50], (byte)altResult[8], (byte)altResult[29], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[9], (byte)altResult[30], (byte)altResult[51], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[31], (byte)altResult[52], (byte)altResult[10], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[53], (byte)altResult[11], (byte)altResult[32], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[12], (byte)altResult[33], (byte)altResult[54], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[34], (byte)altResult[55], (byte)altResult[13], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[56], (byte)altResult[14], (byte)altResult[35], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[15], (byte)altResult[36], (byte)altResult[57], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[37], (byte)altResult[58], (byte)altResult[16], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[59], (byte)altResult[17], (byte)altResult[38], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[18], (byte)altResult[39], (byte)altResult[60], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[40], (byte)altResult[61], (byte)altResult[19], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)altResult[62], (byte)altResult[20], (byte)altResult[41], (int)4, (StringBuilder)buffer);
            B64.b64from24bit((byte)0, (byte)0, (byte)altResult[63], (int)2, (StringBuilder)buffer);
        }
        Arrays.fill(tempResult, (byte)0);
        Arrays.fill(pBytes, (byte)0);
        Arrays.fill(sBytes, (byte)0);
        ctx.reset();
        altCtx.reset();
        Arrays.fill(keyBytes, (byte)0);
        Arrays.fill(saltBytes, (byte)0);
        return buffer.toString();
    }

    public static String sha512Crypt(byte[] keyBytes) {
        return Sha2Crypt.sha512Crypt((byte[])keyBytes, null);
    }

    public static String sha512Crypt(byte[] keyBytes, String salt) {
        if (salt == null) {
            salt = "$6$" + B64.getRandomSalt((int)8);
        }
        return Sha2Crypt.sha2Crypt((byte[])keyBytes, (String)salt, (String)"$6$", (int)64, (String)"SHA-512");
    }

    public static String sha512Crypt(byte[] keyBytes, String salt, Random random) {
        if (salt == null) {
            salt = "$6$" + B64.getRandomSalt((int)8, (Random)random);
        }
        return Sha2Crypt.sha2Crypt((byte[])keyBytes, (String)salt, (String)"$6$", (int)64, (String)"SHA-512");
    }
}

