/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.language.DoubleMetaphone;

/*
 * Exception performing whole class analysis ignored.
 */
public class DoubleMetaphone
implements StringEncoder {
    private static final String VOWELS = "AEIOUY";
    private static final String[] SILENT_START = new String[]{"GN", "KN", "PN", "WR", "PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
    private int maxCodeLen = 4;

    public String doubleMetaphone(String value) {
        return this.doubleMetaphone(value, false);
    }

    public String doubleMetaphone(String value, boolean alternate) {
        if ((value = this.cleanInput(value)) == null) {
            return null;
        }
        boolean slavoGermanic = this.isSlavoGermanic(value);
        int index = this.isSilentStart(value) ? 1 : 0;
        DoubleMetaphoneResult result = new DoubleMetaphoneResult(this, this.getMaxCodeLen());
        block25: while (!result.isComplete() && index <= value.length() - 1) {
            switch (value.charAt(index)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    index = this.handleAEIOUY(result, index);
                    continue block25;
                }
                case 'B': {
                    result.append('P');
                    index = this.charAt(value, index + 1) == 'B' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00c7': {
                    result.append('S');
                    ++index;
                    continue block25;
                }
                case 'C': {
                    index = this.handleC(value, result, index);
                    continue block25;
                }
                case 'D': {
                    index = this.handleD(value, result, index);
                    continue block25;
                }
                case 'F': {
                    result.append('F');
                    index = this.charAt(value, index + 1) == 'F' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'G': {
                    index = this.handleG(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'H': {
                    index = this.handleH(value, result, index);
                    continue block25;
                }
                case 'J': {
                    index = this.handleJ(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'K': {
                    result.append('K');
                    index = this.charAt(value, index + 1) == 'K' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'L': {
                    index = this.handleL(value, result, index);
                    continue block25;
                }
                case 'M': {
                    result.append('M');
                    index = this.conditionM0(value, index) ? index + 2 : index + 1;
                    continue block25;
                }
                case 'N': {
                    result.append('N');
                    index = this.charAt(value, index + 1) == 'N' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00d1': {
                    result.append('N');
                    ++index;
                    continue block25;
                }
                case 'P': {
                    index = this.handleP(value, result, index);
                    continue block25;
                }
                case 'Q': {
                    result.append('K');
                    index = this.charAt(value, index + 1) == 'Q' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'R': {
                    index = this.handleR(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'S': {
                    index = this.handleS(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'T': {
                    index = this.handleT(value, result, index);
                    continue block25;
                }
                case 'V': {
                    result.append('F');
                    index = this.charAt(value, index + 1) == 'V' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'W': {
                    index = this.handleW(value, result, index);
                    continue block25;
                }
                case 'X': {
                    index = this.handleX(value, result, index);
                    continue block25;
                }
                case 'Z': {
                    index = this.handleZ(value, result, index, slavoGermanic);
                    continue block25;
                }
            }
            ++index;
        }
        return alternate ? result.getAlternate() : result.getPrimary();
    }

    public Object encode(Object obj) throws EncoderException {
        if (!(obj instanceof String)) {
            throw new EncoderException("DoubleMetaphone encode parameter is not of type String");
        }
        return this.doubleMetaphone((String)obj);
    }

    public String encode(String value) {
        return this.doubleMetaphone(value);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2) {
        return this.isDoubleMetaphoneEqual(value1, value2, false);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2, boolean alternate) {
        return StringUtils.equals((CharSequence)this.doubleMetaphone(value1, alternate), (CharSequence)this.doubleMetaphone(value2, alternate));
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    public void setMaxCodeLen(int maxCodeLen) {
        this.maxCodeLen = maxCodeLen;
    }

    private int handleAEIOUY(DoubleMetaphoneResult result, int index) {
        if (index == 0) {
            result.append('A');
        }
        return index + 1;
    }

    private int handleC(String value, DoubleMetaphoneResult result, int index) {
        if (this.conditionC0(value, index)) {
            result.append('K');
            index += 2;
        } else if (index == 0 && DoubleMetaphone.contains((String)value, (int)index, (int)6, (String[])new String[]{"CAESAR"})) {
            result.append('S');
            index += 2;
        } else if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"CH"})) {
            index = this.handleCH(value, result, index);
        } else if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"CZ"}) && !DoubleMetaphone.contains((String)value, (int)(index - 2), (int)4, (String[])new String[]{"WICZ"})) {
            result.append('S', 'X');
            index += 2;
        } else if (DoubleMetaphone.contains((String)value, (int)(index + 1), (int)3, (String[])new String[]{"CIA"})) {
            result.append('X');
            index += 3;
        } else {
            if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"CC"}) && (index != 1 || this.charAt(value, 0) != 'M')) {
                return this.handleCC(value, result, index);
            }
            if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"CK", "CG", "CQ"})) {
                result.append('K');
                index += 2;
            } else if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"CI", "CE", "CY"})) {
                if (DoubleMetaphone.contains((String)value, (int)index, (int)3, (String[])new String[]{"CIO", "CIE", "CIA"})) {
                    result.append('S', 'X');
                } else {
                    result.append('S');
                }
                index += 2;
            } else {
                result.append('K');
                index = DoubleMetaphone.contains((String)value, (int)(index + 1), (int)2, (String[])new String[]{" C", " Q", " G"}) ? (index += 3) : (DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])new String[]{"C", "K", "Q"}) && !DoubleMetaphone.contains((String)value, (int)(index + 1), (int)2, (String[])new String[]{"CE", "CI"}) ? (index += 2) : ++index);
            }
        }
        return index;
    }

    private int handleCC(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains((String)value, (int)(index + 2), (int)1, (String[])new String[]{"I", "E", "H"}) && !DoubleMetaphone.contains((String)value, (int)(index + 2), (int)2, (String[])new String[]{"HU"})) {
            if (index == 1 && this.charAt(value, index - 1) == 'A' || DoubleMetaphone.contains((String)value, (int)(index - 1), (int)5, (String[])new String[]{"UCCEE", "UCCES"})) {
                result.append("KS");
            } else {
                result.append('X');
            }
            index += 3;
        } else {
            result.append('K');
            index += 2;
        }
        return index;
    }

    private int handleCH(String value, DoubleMetaphoneResult result, int index) {
        if (index > 0 && DoubleMetaphone.contains((String)value, (int)index, (int)4, (String[])new String[]{"CHAE"})) {
            result.append('K', 'X');
            return index + 2;
        }
        if (this.conditionCH0(value, index)) {
            result.append('K');
            return index + 2;
        }
        if (this.conditionCH1(value, index)) {
            result.append('K');
            return index + 2;
        }
        if (index > 0) {
            if (DoubleMetaphone.contains((String)value, (int)0, (int)2, (String[])new String[]{"MC"})) {
                result.append('K');
            } else {
                result.append('X', 'K');
            }
        } else {
            result.append('X');
        }
        return index + 2;
    }

    private int handleD(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"DG"})) {
            if (DoubleMetaphone.contains((String)value, (int)(index + 2), (int)1, (String[])new String[]{"I", "E", "Y"})) {
                result.append('J');
                index += 3;
            } else {
                result.append("TK");
                index += 2;
            }
        } else if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"DT", "DD"})) {
            result.append('T');
            index += 2;
        } else {
            result.append('T');
            ++index;
        }
        return index;
    }

    private int handleG(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (this.charAt(value, index + 1) == 'H') {
            index = this.handleGH(value, result, index);
        } else if (this.charAt(value, index + 1) == 'N') {
            if (index == 1 && this.isVowel(this.charAt(value, 0)) && !slavoGermanic) {
                result.append("KN", "N");
            } else if (!DoubleMetaphone.contains((String)value, (int)(index + 2), (int)2, (String[])new String[]{"EY"}) && this.charAt(value, index + 1) != 'Y' && !slavoGermanic) {
                result.append("N", "KN");
            } else {
                result.append("KN");
            }
            index += 2;
        } else if (DoubleMetaphone.contains((String)value, (int)(index + 1), (int)2, (String[])new String[]{"LI"}) && !slavoGermanic) {
            result.append("KL", "L");
            index += 2;
        } else if (index == 0 && (this.charAt(value, index + 1) == 'Y' || DoubleMetaphone.contains((String)value, (int)(index + 1), (int)2, (String[])ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
            result.append('K', 'J');
            index += 2;
        } else if (!(!DoubleMetaphone.contains((String)value, (int)(index + 1), (int)2, (String[])new String[]{"ER"}) && this.charAt(value, index + 1) != 'Y' || DoubleMetaphone.contains((String)value, (int)0, (int)6, (String[])new String[]{"DANGER", "RANGER", "MANGER"}) || DoubleMetaphone.contains((String)value, (int)(index - 1), (int)1, (String[])new String[]{"E", "I"}) || DoubleMetaphone.contains((String)value, (int)(index - 1), (int)3, (String[])new String[]{"RGY", "OGY"}))) {
            result.append('K', 'J');
            index += 2;
        } else if (DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])new String[]{"E", "I", "Y"}) || DoubleMetaphone.contains((String)value, (int)(index - 1), (int)4, (String[])new String[]{"AGGI", "OGGI"})) {
            if (DoubleMetaphone.contains((String)value, (int)0, (int)4, (String[])new String[]{"VAN ", "VON "}) || DoubleMetaphone.contains((String)value, (int)0, (int)3, (String[])new String[]{"SCH"}) || DoubleMetaphone.contains((String)value, (int)(index + 1), (int)2, (String[])new String[]{"ET"})) {
                result.append('K');
            } else if (DoubleMetaphone.contains((String)value, (int)(index + 1), (int)3, (String[])new String[]{"IER"})) {
                result.append('J');
            } else {
                result.append('J', 'K');
            }
            index += 2;
        } else if (this.charAt(value, index + 1) == 'G') {
            index += 2;
            result.append('K');
        } else {
            ++index;
            result.append('K');
        }
        return index;
    }

    private int handleGH(String value, DoubleMetaphoneResult result, int index) {
        if (index > 0 && !this.isVowel(this.charAt(value, index - 1))) {
            result.append('K');
            index += 2;
        } else if (index == 0) {
            if (this.charAt(value, index + 2) == 'I') {
                result.append('J');
            } else {
                result.append('K');
            }
            index += 2;
        } else if (index > 1 && DoubleMetaphone.contains((String)value, (int)(index - 2), (int)1, (String[])new String[]{"B", "H", "D"}) || index > 2 && DoubleMetaphone.contains((String)value, (int)(index - 3), (int)1, (String[])new String[]{"B", "H", "D"}) || index > 3 && DoubleMetaphone.contains((String)value, (int)(index - 4), (int)1, (String[])new String[]{"B", "H"})) {
            index += 2;
        } else {
            if (index > 2 && this.charAt(value, index - 1) == 'U' && DoubleMetaphone.contains((String)value, (int)(index - 3), (int)1, (String[])new String[]{"C", "G", "L", "R", "T"})) {
                result.append('F');
            } else if (index > 0 && this.charAt(value, index - 1) != 'I') {
                result.append('K');
            }
            index += 2;
        }
        return index;
    }

    private int handleH(String value, DoubleMetaphoneResult result, int index) {
        if ((index == 0 || this.isVowel(this.charAt(value, index - 1))) && this.isVowel(this.charAt(value, index + 1))) {
            result.append('H');
            index += 2;
        } else {
            ++index;
        }
        return index;
    }

    private int handleJ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (DoubleMetaphone.contains((String)value, (int)index, (int)4, (String[])new String[]{"JOSE"}) || DoubleMetaphone.contains((String)value, (int)0, (int)4, (String[])new String[]{"SAN "})) {
            if (index == 0 && this.charAt(value, index + 4) == ' ' || value.length() == 4 || DoubleMetaphone.contains((String)value, (int)0, (int)4, (String[])new String[]{"SAN "})) {
                result.append('H');
            } else {
                result.append('J', 'H');
            }
            ++index;
        } else {
            if (index == 0 && !DoubleMetaphone.contains((String)value, (int)index, (int)4, (String[])new String[]{"JOSE"})) {
                result.append('J', 'A');
            } else if (this.isVowel(this.charAt(value, index - 1)) && !slavoGermanic && (this.charAt(value, index + 1) == 'A' || this.charAt(value, index + 1) == 'O')) {
                result.append('J', 'H');
            } else if (index == value.length() - 1) {
                result.append('J', ' ');
            } else if (!DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains((String)value, (int)(index - 1), (int)1, (String[])new String[]{"S", "K", "L"})) {
                result.append('J');
            }
            index = this.charAt(value, index + 1) == 'J' ? (index += 2) : ++index;
        }
        return index;
    }

    private int handleL(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 1) == 'L') {
            if (this.conditionL0(value, index)) {
                result.appendPrimary('L');
            } else {
                result.append('L');
            }
            index += 2;
        } else {
            ++index;
            result.append('L');
        }
        return index;
    }

    private int handleP(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 1) == 'H') {
            result.append('F');
            index += 2;
        } else {
            result.append('P');
            index = DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])new String[]{"P", "B"}) ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleR(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (index == value.length() - 1 && !slavoGermanic && DoubleMetaphone.contains((String)value, (int)(index - 2), (int)2, (String[])new String[]{"IE"}) && !DoubleMetaphone.contains((String)value, (int)(index - 4), (int)2, (String[])new String[]{"ME", "MA"})) {
            result.appendAlternate('R');
        } else {
            result.append('R');
        }
        return this.charAt(value, index + 1) == 'R' ? index + 2 : index + 1;
    }

    private int handleS(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (DoubleMetaphone.contains((String)value, (int)(index - 1), (int)3, (String[])new String[]{"ISL", "YSL"})) {
            ++index;
        } else if (index == 0 && DoubleMetaphone.contains((String)value, (int)index, (int)5, (String[])new String[]{"SUGAR"})) {
            result.append('X', 'S');
            ++index;
        } else if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"SH"})) {
            if (DoubleMetaphone.contains((String)value, (int)(index + 1), (int)4, (String[])new String[]{"HEIM", "HOEK", "HOLM", "HOLZ"})) {
                result.append('S');
            } else {
                result.append('X');
            }
            index += 2;
        } else if (DoubleMetaphone.contains((String)value, (int)index, (int)3, (String[])new String[]{"SIO", "SIA"}) || DoubleMetaphone.contains((String)value, (int)index, (int)4, (String[])new String[]{"SIAN"})) {
            if (slavoGermanic) {
                result.append('S');
            } else {
                result.append('S', 'X');
            }
            index += 3;
        } else if (index == 0 && DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])new String[]{"M", "N", "L", "W"}) || DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])new String[]{"Z"})) {
            result.append('S', 'X');
            index = DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])new String[]{"Z"}) ? index + 2 : index + 1;
        } else if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"SC"})) {
            index = this.handleSC(value, result, index);
        } else {
            if (index == value.length() - 1 && DoubleMetaphone.contains((String)value, (int)(index - 2), (int)2, (String[])new String[]{"AI", "OI"})) {
                result.appendAlternate('S');
            } else {
                result.append('S');
            }
            index = DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])new String[]{"S", "Z"}) ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleSC(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 2) == 'H') {
            if (DoubleMetaphone.contains((String)value, (int)(index + 3), (int)2, (String[])new String[]{"OO", "ER", "EN", "UY", "ED", "EM"})) {
                if (DoubleMetaphone.contains((String)value, (int)(index + 3), (int)2, (String[])new String[]{"ER", "EN"})) {
                    result.append("X", "SK");
                } else {
                    result.append("SK");
                }
            } else if (index == 0 && !this.isVowel(this.charAt(value, 3)) && this.charAt(value, 3) != 'W') {
                result.append('X', 'S');
            } else {
                result.append('X');
            }
        } else if (DoubleMetaphone.contains((String)value, (int)(index + 2), (int)1, (String[])new String[]{"I", "E", "Y"})) {
            result.append('S');
        } else {
            result.append("SK");
        }
        return index + 3;
    }

    private int handleT(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains((String)value, (int)index, (int)4, (String[])new String[]{"TION"})) {
            result.append('X');
            index += 3;
        } else if (DoubleMetaphone.contains((String)value, (int)index, (int)3, (String[])new String[]{"TIA", "TCH"})) {
            result.append('X');
            index += 3;
        } else if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"TH"}) || DoubleMetaphone.contains((String)value, (int)index, (int)3, (String[])new String[]{"TTH"})) {
            if (DoubleMetaphone.contains((String)value, (int)(index + 2), (int)2, (String[])new String[]{"OM", "AM"}) || DoubleMetaphone.contains((String)value, (int)0, (int)4, (String[])new String[]{"VAN ", "VON "}) || DoubleMetaphone.contains((String)value, (int)0, (int)3, (String[])new String[]{"SCH"})) {
                result.append('T');
            } else {
                result.append('0', 'T');
            }
            index += 2;
        } else {
            result.append('T');
            index = DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])new String[]{"T", "D"}) ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleW(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"WR"})) {
            result.append('R');
            index += 2;
        } else if (index == 0 && (this.isVowel(this.charAt(value, index + 1)) || DoubleMetaphone.contains((String)value, (int)index, (int)2, (String[])new String[]{"WH"}))) {
            if (this.isVowel(this.charAt(value, index + 1))) {
                result.append('A', 'F');
            } else {
                result.append('A');
            }
            ++index;
        } else if (index == value.length() - 1 && this.isVowel(this.charAt(value, index - 1)) || DoubleMetaphone.contains((String)value, (int)(index - 1), (int)5, (String[])new String[]{"EWSKI", "EWSKY", "OWSKI", "OWSKY"}) || DoubleMetaphone.contains((String)value, (int)0, (int)3, (String[])new String[]{"SCH"})) {
            result.appendAlternate('F');
            ++index;
        } else if (DoubleMetaphone.contains((String)value, (int)index, (int)4, (String[])new String[]{"WICZ", "WITZ"})) {
            result.append("TS", "FX");
            index += 4;
        } else {
            ++index;
        }
        return index;
    }

    private int handleX(String value, DoubleMetaphoneResult result, int index) {
        if (index == 0) {
            result.append('S');
            ++index;
        } else {
            if (index != value.length() - 1 || !DoubleMetaphone.contains((String)value, (int)(index - 3), (int)3, (String[])new String[]{"IAU", "EAU"}) && !DoubleMetaphone.contains((String)value, (int)(index - 2), (int)2, (String[])new String[]{"AU", "OU"})) {
                result.append("KS");
            }
            index = DoubleMetaphone.contains((String)value, (int)(index + 1), (int)1, (String[])new String[]{"C", "X"}) ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleZ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (this.charAt(value, index + 1) == 'H') {
            result.append('J');
            index += 2;
        } else {
            if (DoubleMetaphone.contains((String)value, (int)(index + 1), (int)2, (String[])new String[]{"ZO", "ZI", "ZA"}) || slavoGermanic && index > 0 && this.charAt(value, index - 1) != 'T') {
                result.append("S", "TS");
            } else {
                result.append('S');
            }
            index = this.charAt(value, index + 1) == 'Z' ? index + 2 : index + 1;
        }
        return index;
    }

    private boolean conditionC0(String value, int index) {
        if (DoubleMetaphone.contains((String)value, (int)index, (int)4, (String[])new String[]{"CHIA"})) {
            return true;
        }
        if (index <= 1) {
            return false;
        }
        if (this.isVowel(this.charAt(value, index - 2))) {
            return false;
        }
        if (!DoubleMetaphone.contains((String)value, (int)(index - 1), (int)3, (String[])new String[]{"ACH"})) {
            return false;
        }
        char c = this.charAt(value, index + 2);
        return c != 'I' && c != 'E' || DoubleMetaphone.contains((String)value, (int)(index - 2), (int)6, (String[])new String[]{"BACHER", "MACHER"});
    }

    private boolean conditionCH0(String value, int index) {
        if (index != 0) {
            return false;
        }
        if (!DoubleMetaphone.contains((String)value, (int)(index + 1), (int)5, (String[])new String[]{"HARAC", "HARIS"}) && !DoubleMetaphone.contains((String)value, (int)(index + 1), (int)3, (String[])new String[]{"HOR", "HYM", "HIA", "HEM"})) {
            return false;
        }
        return !DoubleMetaphone.contains((String)value, (int)0, (int)5, (String[])new String[]{"CHORE"});
    }

    private boolean conditionCH1(String value, int index) {
        return DoubleMetaphone.contains((String)value, (int)0, (int)4, (String[])new String[]{"VAN ", "VON "}) || DoubleMetaphone.contains((String)value, (int)0, (int)3, (String[])new String[]{"SCH"}) || DoubleMetaphone.contains((String)value, (int)(index - 2), (int)6, (String[])new String[]{"ORCHES", "ARCHIT", "ORCHID"}) || DoubleMetaphone.contains((String)value, (int)(index + 2), (int)1, (String[])new String[]{"T", "S"}) || (DoubleMetaphone.contains((String)value, (int)(index - 1), (int)1, (String[])new String[]{"A", "O", "U", "E"}) || index == 0) && (DoubleMetaphone.contains((String)value, (int)(index + 2), (int)1, (String[])L_R_N_M_B_H_F_V_W_SPACE) || index + 1 == value.length() - 1);
    }

    private boolean conditionL0(String value, int index) {
        if (index == value.length() - 3 && DoubleMetaphone.contains((String)value, (int)(index - 1), (int)4, (String[])new String[]{"ILLO", "ILLA", "ALLE"})) {
            return true;
        }
        return (DoubleMetaphone.contains((String)value, (int)(value.length() - 2), (int)2, (String[])new String[]{"AS", "OS"}) || DoubleMetaphone.contains((String)value, (int)(value.length() - 1), (int)1, (String[])new String[]{"A", "O"})) && DoubleMetaphone.contains((String)value, (int)(index - 1), (int)4, (String[])new String[]{"ALLE"});
    }

    private boolean conditionM0(String value, int index) {
        if (this.charAt(value, index + 1) == 'M') {
            return true;
        }
        return DoubleMetaphone.contains((String)value, (int)(index - 1), (int)3, (String[])new String[]{"UMB"}) && (index + 1 == value.length() - 1 || DoubleMetaphone.contains((String)value, (int)(index + 2), (int)2, (String[])new String[]{"ER"}));
    }

    private boolean isSlavoGermanic(String value) {
        return value.indexOf(87) > -1 || value.indexOf(75) > -1 || value.indexOf("CZ") > -1 || value.indexOf("WITZ") > -1;
    }

    private boolean isVowel(char ch) {
        return "AEIOUY".indexOf(ch) != -1;
    }

    private boolean isSilentStart(String value) {
        boolean result = false;
        for (String element : SILENT_START) {
            if (!value.startsWith(element)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String cleanInput(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return null;
        }
        return input.toUpperCase(Locale.ENGLISH);
    }

    protected char charAt(String value, int index) {
        if (index < 0 || index >= value.length()) {
            return '\u0000';
        }
        return value.charAt(index);
    }

    protected static boolean contains(String value, int start, int length, String ... criteria) {
        boolean result = false;
        if (start >= 0 && start + length <= value.length()) {
            String target = value.substring(start, start + length);
            for (String element : criteria) {
                if (!target.equals(element)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

