/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.codec.Resources;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;

/*
 * Exception performing whole class analysis ignored.
 */
public class Languages {
    public static final String ANY = "any";
    private static final Map<NameType, Languages> LANGUAGES = new EnumMap(NameType.class);
    private final Set<String> languages;
    public static final LanguageSet NO_LANGUAGES;
    public static final LanguageSet ANY_LANGUAGE;

    public static Languages getInstance(NameType nameType) {
        return (Languages)LANGUAGES.get(nameType);
    }

    public static Languages getInstance(String languagesResourceName) {
        HashSet<String> ls = new HashSet<String>();
        try (Scanner lsScanner = new Scanner(Resources.getInputStream((String)languagesResourceName), "UTF-8");){
            boolean inExtendedComment = false;
            while (lsScanner.hasNextLine()) {
                String line = lsScanner.nextLine().trim();
                if (inExtendedComment) {
                    if (!line.endsWith("*/")) continue;
                    inExtendedComment = false;
                    continue;
                }
                if (line.startsWith("/*")) {
                    inExtendedComment = true;
                    continue;
                }
                if (line.length() <= 0) continue;
                ls.add(line);
            }
            Languages languages = new Languages(Collections.unmodifiableSet(ls));
            return languages;
        }
    }

    private static String langResourceName(NameType nameType) {
        return String.format("org/apache/commons/codec/language/bm/%s_languages.txt", nameType.getName());
    }

    private Languages(Set<String> languages) {
        this.languages = languages;
    }

    public Set<String> getLanguages() {
        return this.languages;
    }

    static {
        for (NameType s : NameType.values()) {
            LANGUAGES.put(s, Languages.getInstance((String)Languages.langResourceName((NameType)s)));
        }
        NO_LANGUAGES = new /* Unavailable Anonymous Inner Class!! */;
        ANY_LANGUAGE = new /* Unavailable Anonymous Inner Class!! */;
    }
}

